/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.essence;

import com.cmdpro.datanessence.api.essence.EssenceType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public interface EssenceStorage {
    public static float transferEssence(@NotNull EssenceStorage source, @NotNull EssenceStorage destination, @NotNull EssenceType type, float amount) {
        if (source.getEssence(type) > 0.0f && destination.getMaxEssence() > 0.0f) {
            float transferred = Math.clamp((float)0.0f, (float)(destination.getMaxEssence() - destination.getEssence(type)), (float)Math.min((float)source.getEssence(type), (float)amount));
            source.removeEssence(type, transferred);
            destination.addEssence(type, transferred);
            return transferred;
        }
        return 0.0f;
    }

    default public float getEssence(EssenceType type) {
        return this.getStorage().getEssence(type);
    }

    default public void addEssence(EssenceType type, float amount) {
        this.getStorage().addEssence(type, amount);
    }

    default public void removeEssence(EssenceType type, float amount) {
        this.getStorage().removeEssence(type, amount);
    }

    default public float getMaxEssence() {
        return this.getStorage().getMaxEssence();
    }

    public EssenceStorage getStorage();

    public Set<EssenceType> getSupportedEssenceTypes();
}

