/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.neoforged.neoforge.common.util.TriState;

public class SpreadingPlant
extends Block {
    public int spreadChance;
    public int plantLimit;

    public SpreadingPlant(BlockBehaviour.Properties properties, int spreadChance, int plantLimit) {
        super(properties);
        this.spreadChance = spreadChance;
        this.plantLimit = plantLimit;
    }

    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.grow(state, world, pos, random, this.spreadChance);
    }

    public void grow(BlockState state, ServerLevel world, BlockPos pos, RandomSource random, int chance) {
        if (random.nextInt(chance) == 0) {
            for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-4, -1, -4), (BlockPos)pos.offset(4, 1, 4))) {
                if (!world.getBlockState(blockpos).is((Block)this) || --this.plantLimit > 0) continue;
                return;
            }
            BlockPos blockpos1 = pos.offset(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (world.isEmptyBlock(blockpos1) && state.canSurvive((LevelReader)world, blockpos1)) {
                    pos = blockpos1;
                }
                blockpos1 = pos.offset(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
            }
            if (world.isEmptyBlock(blockpos1) && state.canSurvive((LevelReader)world, blockpos1)) {
                world.setBlock(blockpos1, state, 2);
            }
        }
    }

    protected boolean isRandomlyTicking(BlockState pState) {
        return true;
    }

    protected boolean mayPlaceOn(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.is(BlockTags.DIRT) || pState.getBlock() instanceof FarmBlock;
    }

    protected BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    protected boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.below();
        BlockState belowBlockState = pLevel.getBlockState(blockpos);
        TriState soilDecision = belowBlockState.canSustainPlant((BlockGetter)pLevel, blockpos, Direction.UP, pState);
        if (!soilDecision.isDefault()) {
            return soilDecision.isTrue();
        }
        return this.mayPlaceOn(belowBlockState, (BlockGetter)pLevel, blockpos);
    }

    protected boolean propagatesSkylightDown(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return pState.getFluidState().isEmpty();
    }

    protected boolean isPathfindable(BlockState pState, PathComputationType pPathComputationType) {
        return pPathComputationType == PathComputationType.AIR && !this.hasCollision || super.isPathfindable(pState, pPathComputationType);
    }
}

