/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.block;

import com.cmdpro.datanessence.api.block.BaseFabricatorBlockEntity;
import com.cmdpro.datanessence.api.block.RedirectorInteractable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFabricatorBlock
extends Block
implements EntityBlock,
RedirectorInteractable {
    public BaseFabricatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof BaseFabricatorBlockEntity) {
            ((BaseFabricatorBlockEntity)blockEntity).drops();
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @Override
    public boolean onRedirectorUse(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = world.getBlockState(pos);
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BaseFabricatorBlockEntity) {
            BaseFabricatorBlockEntity fabricator = (BaseFabricatorBlockEntity)blockEntity;
            BaseFabricatorBlockEntity.use(state, world, pos, player, hand);
        }
        return true;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return (lvl, pos, st, blockEntity) -> {
            if (blockEntity instanceof BaseFabricatorBlockEntity) {
                BaseFabricatorBlockEntity ent = (BaseFabricatorBlockEntity)blockEntity;
                ent.tick(lvl, pos, st, ent);
            }
        };
    }
}

