/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.sgearmetalworks.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import cy.jdkdigital.productivebees.common.crafting.conditions.BeeExistsCondition;
import cy.jdkdigital.productivebees.common.crafting.ingredient.ComponentIngredient;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivelib.common.condition.LazyCondition;
import cy.jdkdigital.productivelib.crafting.condition.FluidTagEmptyCondition;
import cy.jdkdigital.productivemetalworks.datagen.recipe.BlockCastingRecipeBuilder;
import cy.jdkdigital.productivemetalworks.datagen.recipe.FluidAlloyingRecipeBuilder;
import cy.jdkdigital.productivemetalworks.datagen.recipe.ItemCastingRecipeBuilder;
import cy.jdkdigital.productivemetalworks.datagen.recipe.ItemMeltingRecipeBuilder;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import cy.jdkdigital.sgearmetalworks.datagen.recipe.GearComponentIngredient;
import cy.jdkdigital.sgearmetalworks.datagen.recipe.SilentGearCastingRecipeBuilder;
import cy.jdkdigital.sgearmetalworks.registry.ModTags;
import cy.jdkdigital.sgearmetalworks.registry.SGearMetalworksRegistrator;
import cy.jdkdigital.sgearmetalworks.util.CastingMaterialCategories;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.TagFluidIngredient;
import net.neoforged.neoforge.registries.DeferredItem;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.crafting.ingredient.BlueprintIngredient;
import net.silentchaos512.gear.crafting.ingredient.GearPartIngredient;
import net.silentchaos512.gear.crafting.ingredient.PartMaterialIngredient;
import net.silentchaos512.gear.crafting.recipe.ShapedGearRecipe;
import net.silentchaos512.gear.crafting.recipe.ShapelessCompoundPartRecipe;
import net.silentchaos512.gear.crafting.recipe.ShapelessGearRecipe;
import net.silentchaos512.gear.gear.material.MaterialCategories;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.GearItemSet;
import net.silentchaos512.gear.item.blueprint.PartBlueprintItem;
import net.silentchaos512.gear.item.gear.GearArmorItem;
import net.silentchaos512.gear.setup.GearItemSets;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.SgTags;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gems.util.Gems;
import net.silentchaos512.lib.data.recipe.ExtendedShapedRecipeBuilder;
import net.silentchaos512.lib.data.recipe.ExtendedShapelessRecipeBuilder;
import net.silentchaos512.lib.util.NameUtils;

public class RecipeProvider
extends net.minecraft.data.recipes.RecipeProvider
implements IConditionBuilder {
    static String[] SGM_METALS = new String[]{"sgearmetalworks:uru_metal"};
    static String[] SG_METALS = new String[]{"silentgear:crimson_iron", "silentgear:crimson_steel", "silentgear:blaze_gold", "silentgear:azure_silver", "silentgear:azure_electrum", "silentgear:tyrian_steel"};

    public RecipeProvider(PackOutput gen, CompletableFuture<HolderLookup.Provider> registries) {
        super(gen, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ItemMeltingRecipeBuilder.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"silentgear", (String)"crushed_shulker_shell"))}), (FluidStack)new FluidStack((Fluid)MetalworksRegistrator.MOLTEN_SHULKER_SHELL.get(), 100)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"melting/crushed_shulker_shell"));
        RecipeProvider.alloyRecipe(List.of(SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_CRIMSON_IRON, (int)810), SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_BLAZE, (int)200), SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_MAGMA_CREAM, (int)100)), 1, new FluidStack(SGearMetalworksRegistrator.MOLTEN_CRIMSON_STEEL, 270), recipeOutput);
        RecipeProvider.alloyRecipe(List.of(SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_GOLD, (int)90), SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_BLAZE, (int)200)), 1, new FluidStack(SGearMetalworksRegistrator.MOLTEN_BLAZE_GOLD, 90), recipeOutput);
        RecipeProvider.alloyRecipe(List.of(SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_AZURE_SILVER, (int)360), SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_GOLD, (int)180), SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_ENDER, (int)100)), 1, new FluidStack(SGearMetalworksRegistrator.MOLTEN_AZURE_ELECTRUM, 90), recipeOutput);
        RecipeProvider.alloyRecipe(List.of(SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_CRIMSON_STEEL, (int)90), SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_AZURE_ELECTRUM, (int)90), SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_SHULKER_SHELL, (int)100), SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_ANCIENT_DEBRIS, (int)100)), 1, new FluidStack(SGearMetalworksRegistrator.MOLTEN_TYRIAN_STEEL, 360), recipeOutput);
        RecipeProvider.alloyRecipe(List.of(SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_HEAVY_CORE, (int)180), SizedFluidIngredient.of(ModTags.Fluids.MEAT, (int)180), SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_AZURE_ELECTRUM, (int)90), SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_TYRIAN_STEEL, (int)90), SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_SHULKER_SHELL, (int)100), SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_ANCIENT_DEBRIS, (int)100)), 1, new FluidStack(SGearMetalworksRegistrator.MOLTEN_URU_METAL, 90), recipeOutput.withConditions(new ICondition[]{new NotCondition((ICondition)new ModLoadedCondition("allthemodium"))}));
        RecipeProvider.alloyRecipe(List.of(SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_HEAVY_CORE, (int)180), SizedFluidIngredient.of(ModTags.Fluids.MEAT, (int)180), SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_TYRIAN_STEEL, (int)90), SizedFluidIngredient.of((Fluid)((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)"allthemodium:molten_allthemodium"))), (int)90), SizedFluidIngredient.of((Fluid)((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)"allthemodium:molten_vibranium"))), (int)90), SizedFluidIngredient.of((Fluid)((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)"allthemodium:molten_unobtainium"))), (int)90)), 1, new FluidStack(SGearMetalworksRegistrator.MOLTEN_URU_METAL, 90), recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("allthemodium")}), "alloying/atm/molten_uru_metal");
        ItemMeltingRecipeBuilder.of((Ingredient)Ingredient.of(ModTags.Items.URU_METAL_STORAGE_BLOCKS), (FluidStack)new FluidStack(SGearMetalworksRegistrator.MOLTEN_URU_METAL, 800), (int)3000, (int)30000).save(recipeOutput, "melting/uru_metal_block");
        ItemMeltingRecipeBuilder.of((Ingredient)Ingredient.of(ModTags.Items.URU_METAL_INGOTS), (FluidStack)new FluidStack(SGearMetalworksRegistrator.MOLTEN_URU_METAL, 90), (int)3000, (int)30000).save(recipeOutput, "melting/uru_metal_ingot");
        ItemMeltingRecipeBuilder.of((Ingredient)Ingredient.of(ModTags.Items.URU_METAL_NUGGETS), (FluidStack)new FluidStack(SGearMetalworksRegistrator.MOLTEN_URU_METAL, 10), (int)3000, (int)30000).save(recipeOutput, "melting/uru_metal_nugget");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SGearMetalworksRegistrator.URU_METAL_NUGGET.get()), (int)9).requires((ItemLike)SGearMetalworksRegistrator.URU_METAL_INGOT.get()).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)SGearMetalworksRegistrator.URU_METAL_INGOT.get())), RecipeProvider.has((ItemLike)((ItemLike)SGearMetalworksRegistrator.URU_METAL_INGOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"crafting/uru_metal_nugget_from_ingot"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SGearMetalworksRegistrator.URU_METAL_INGOT.get()), (int)9).requires((ItemLike)SGearMetalworksRegistrator.URU_METAL_BLOCK.get()).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)SGearMetalworksRegistrator.URU_METAL_BLOCK.get())), RecipeProvider.has((ItemLike)((ItemLike)SGearMetalworksRegistrator.URU_METAL_BLOCK.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"crafting/uru_metal_ingot_from_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SGearMetalworksRegistrator.URU_METAL_INGOT.get()), (int)1).requires((ItemLike)SGearMetalworksRegistrator.URU_METAL_NUGGET.get(), 9).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)SGearMetalworksRegistrator.URU_METAL_NUGGET.get())), RecipeProvider.has((ItemLike)((ItemLike)SGearMetalworksRegistrator.URU_METAL_NUGGET.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"crafting/uru_metal_ingot_from_nugget"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)SGearMetalworksRegistrator.URU_METAL_BLOCK.get()), (int)1).requires((ItemLike)SGearMetalworksRegistrator.URU_METAL_INGOT.get(), 9).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)SGearMetalworksRegistrator.URU_METAL_INGOT.get())), RecipeProvider.has((ItemLike)((ItemLike)SGearMetalworksRegistrator.URU_METAL_INGOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"crafting/uru_metal_block_from_ingot"));
        cy.jdkdigital.productivemetalworks.datagen.RecipeProvider.metalCompat((String)"sgearmetalworks", (String[])SG_METALS, (RecipeOutput)recipeOutput);
        cy.jdkdigital.productivemetalworks.datagen.RecipeProvider.modMetalCompat((String)"sgearmetalworks", (String[])SGM_METALS, (RecipeOutput)recipeOutput);
        cy.jdkdigital.productivemetalworks.datagen.RecipeProvider.modMetalCompat((String)"silentgear", (String[])SG_METALS, (RecipeOutput)recipeOutput);
        this.sgemsCompat(recipeOutput);
        RecipeProvider.gearCasting(recipeOutput);
        RecipeProvider.gearCrafting(recipeOutput);
        this.georeCompat(recipeOutput);
        ItemCastingRecipeBuilder.of((Ingredient)ComponentIngredient.of((ItemStack)RecipeProvider.getBeeSpawnEgg("productivebees:beebee")), (SizedFluidIngredient)SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_URU_METAL, (int)800), (ItemStack)RecipeProvider.getBeeSpawnEgg("productivebees:uru_metal"), (boolean)true).save(recipeOutput.withConditions(new ICondition[]{new LazyCondition((ICondition)new BeeExistsCondition(ResourceLocation.parse((String)"productivebees:beebee")))}).withConditions(new ICondition[]{new LazyCondition((ICondition)new BeeExistsCondition(ResourceLocation.parse((String)"productivebees:uru_metal")))}), ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)"casting/uru/bee_spawn_egg_from_bee"));
        ItemCastingRecipeBuilder.of((Ingredient)ComponentIngredient.of((ItemStack)RecipeProvider.getBeeSpawnEgg("productivebees:netherite")), (SizedFluidIngredient)SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_URU_METAL, (int)800), (ItemStack)RecipeProvider.getBeeSpawnEgg("productivebees:uru_metal"), (boolean)true).save(recipeOutput.withConditions(new ICondition[]{new NotCondition((ICondition)new LazyCondition((ICondition)new BeeExistsCondition(ResourceLocation.parse((String)"productivebees:beebee"))))}).withConditions(new ICondition[]{new LazyCondition((ICondition)new BeeExistsCondition(ResourceLocation.parse((String)"productivebees:netherite")))}).withConditions(new ICondition[]{new LazyCondition((ICondition)new BeeExistsCondition(ResourceLocation.parse((String)"productivebees:uru_metal")))}), ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)"casting/uru/bee_spawn_egg_from_netherite"));
        ItemStack combStack = ((Item)ModItems.CONFIGURABLE_HONEYCOMB.get()).getDefaultInstance();
        combStack.set(ModDataComponents.BEE_TYPE, (Object)ResourceLocation.parse((String)"productivebees:uru_metal"));
        ItemMeltingRecipeBuilder.of((Ingredient)ComponentIngredient.of((ItemStack)combStack), (FluidStack)new FluidStack((Fluid)SGearMetalworksRegistrator.MOLTEN_URU_METAL.get(), 10), (int)3000, (int)30000).save(recipeOutput.withConditions(new ICondition[]{new LazyCondition((ICondition)new BeeExistsCondition(ResourceLocation.parse((String)"productivebees:uru_metal")))}), ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)"melting/pbees/uru_metal_comb"));
    }

    private static ItemStack getBeeSpawnEgg(String type) {
        ItemStack inputEgg = new ItemStack((ItemLike)ModItems.CONFIGURABLE_SPAWN_EGG.get());
        CompoundTag inputTag = new CompoundTag();
        inputTag.putString("id", ModEntities.CONFIGURABLE_BEE.getId().toString());
        inputTag.putString("type", type);
        inputEgg.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)inputTag));
        return inputEgg;
    }

    private void sgemsCompat(RecipeOutput recipeOutput) {
        for (Gems gem : Gems.values()) {
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)("molten_" + gem.getName())));
            TagKey fluidTag = FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("molten_" + gem.getName())));
            ItemMeltingRecipeBuilder.of((Ingredient)Ingredient.of((TagKey)gem.getBlockItemTag()), (FluidStack)new FluidStack(fluid, 900)).save(recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("silentgems")}), ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)("melting/storage_blocks/" + gem.getName() + "_block")));
            ItemMeltingRecipeBuilder.of((Ingredient)Ingredient.of((TagKey)gem.getOreItemTag()), (FluidStack)new FluidStack(fluid, 300)).save(recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("silentgems")}), ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)("melting/ores/" + gem.getName())));
            ItemMeltingRecipeBuilder.of((Ingredient)Ingredient.of((TagKey)gem.getItemTag()), (FluidStack)new FluidStack(fluid, 100)).save(recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("silentgems")}), ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)("melting/gems/" + gem.getName())));
            BlockCastingRecipeBuilder.of((SizedFluidIngredient)SizedFluidIngredient.of((TagKey)fluidTag, (int)900), (ItemStack)gem.getBlock().asItem().getDefaultInstance()).save(recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("silentgems")}), ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)("casting/storage_blocks/" + gem.getName())));
            ItemCastingRecipeBuilder.of((ItemStack)((Item)MetalworksRegistrator.CAST_GEM.get()).getDefaultInstance(), (SizedFluidIngredient)SizedFluidIngredient.of((TagKey)fluidTag, (int)100), (ItemStack)gem.getItem().getDefaultInstance()).save(recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("silentgems")}), ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)("casting/gems/" + gem.getName())));
        }
    }

    private static void gearCasting(RecipeOutput recipeOutput) {
        RecipeOutput compatRecipeOutput = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("silentgear")});
        HashMap<String, Pair<PartMaterialIngredient, Integer>> materialCost = new HashMap<String, Pair<PartMaterialIngredient, Integer>>(){
            {
                this.put("sword", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)2));
                this.put("katana", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)3));
                this.put("machete", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)3));
                this.put("spear", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)1));
                this.put("trident", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)3));
                this.put("mace", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)3));
                this.put("knife", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)1));
                this.put("dagger", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)1));
                this.put("pickaxe", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)3));
                this.put("shovel", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)1));
                this.put("axe", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)3));
                this.put("paxel", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)5));
                this.put("hammer", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)6));
                this.put("excavator", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)5));
                this.put("hoe", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)2));
                this.put("mattock", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)4));
                this.put("prospector_hammer", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)2));
                this.put("saw", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)5));
                this.put("sickle", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)3));
                this.put("shears", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)2));
                this.put("fishing_rod", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)2));
                this.put("bow", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)3));
                this.put("crossbow", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)3));
                this.put("slingshot", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)2));
                this.put("arrow", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.PROJECTILE.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)1));
                this.put("ring", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.CURIO.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)2));
                this.put("bracelet", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.CURIO.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)3));
                this.put("necklace", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.CURIO.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)3));
                this.put("helmet", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.HELMET.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)5));
                this.put("chestplate", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.CHESTPLATE.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)8));
                this.put("leggings", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.LEGGINGS.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)7));
                this.put("boots", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.BOOTS.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)4));
                this.put("shield", Pair.of((Object)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.ARMOR.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), (Object)2));
            }
        };
        GearItemSets.getIterator().forEachRemaining(gearItemSet -> {
            ItemStack cast = ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)(gearItemSet.name() + "_cast")))).getDefaultInstance();
            if (!gearItemSet.partName().equals("mace_core") && !gearItemSet.partName().equals("elytra_wings")) {
                ItemCastingRecipeBuilder.of((ItemStack)((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"silentgear", (String)gearItemSet.partName()))).getDefaultInstance(), (SizedFluidIngredient)SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_STEEL, (int)360), (ItemStack)cast, (boolean)true).save(compatRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)("casting/" + gearItemSet.name() + "_cast")));
            }
            Pair amount = (Pair)materialCost.get(gearItemSet.name());
            if (gearItemSet.partName().equals("mace_core")) {
                SilentGearCastingRecipeBuilder.of(Items.HEAVY_CORE.getDefaultInstance(), (PartMaterialIngredient)amount.getFirst(), (int)((Integer)amount.getSecond()), gearItemSet.mainPart().getDefaultInstance(), true).save(compatRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)("casting/silentgear/" + gearItemSet.partName())));
            } else if (!gearItemSet.partName().equals("elytra_wings")) {
                SilentGearCastingRecipeBuilder.of(cast, (PartMaterialIngredient)amount.getFirst(), (int)((Integer)amount.getSecond()), gearItemSet.mainPart().getDefaultInstance(), false).save(compatRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)("casting/silentgear/" + gearItemSet.partName())));
            }
            RecipeProvider.atmCompat(recipeOutput, gearItemSet, (Pair<PartMaterialIngredient, Integer>)amount);
        });
        SilentGearCastingRecipeBuilder.of(((Item)SGearMetalworksRegistrator.CAST_TOOL_ROD.get()).getDefaultInstance(), PartMaterialIngredient.of((PartType)((PartType)PartTypes.ROD.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), 2, ((CompoundPartItem)SgItems.ROD.get()).getDefaultInstance(), false).save(compatRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)"casting/silentgear/tool_rod"));
        SilentGearCastingRecipeBuilder.of(((Item)SGearMetalworksRegistrator.CAST_TIP.get()).getDefaultInstance(), PartMaterialIngredient.of((PartType)((PartType)PartTypes.TIP.get()), (IMaterialCategory[])new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), 2, ((CompoundPartItem)SgItems.TIP.get()).getDefaultInstance(), false).save(compatRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)"casting/silentgear/tip"));
        ItemCastingRecipeBuilder.of((ItemStack)((CompoundPartItem)SgItems.ROD.get()).getDefaultInstance(), (SizedFluidIngredient)SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_STEEL, (int)360), (ItemStack)((Item)SGearMetalworksRegistrator.CAST_TOOL_ROD.get()).getDefaultInstance(), (boolean)true).save(compatRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)"casting/rod_cast"));
        ItemCastingRecipeBuilder.of((ItemStack)((CompoundPartItem)SgItems.TIP.get()).getDefaultInstance(), (SizedFluidIngredient)SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_STEEL, (int)360), (ItemStack)((Item)SGearMetalworksRegistrator.CAST_TIP.get()).getDefaultInstance(), (boolean)true).save(compatRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)"casting/tip_cast"));
        ItemCastingRecipeBuilder.of((ItemStack)((Item)SgItems.NETHER_BANANA.get()).getDefaultInstance(), (SizedFluidIngredient)SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_GOLD, (int)720), (ItemStack)((Item)SgItems.GOLDEN_NETHER_BANANA.get()).getDefaultInstance(), (boolean)true).save(compatRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)"casting/silentgear/golden_nether_banana"));
    }

    private static void gearCrafting(RecipeOutput recipeOutput) {
        RecipeProvider.registerCompoundParts(recipeOutput);
        RecipeProvider.toolRecipes(recipeOutput, "sword", 2, GearItemSets.SWORD);
        RecipeProvider.toolRecipes(recipeOutput, "katana", 3, GearItemSets.KATANA);
        RecipeProvider.toolRecipes(recipeOutput, "machete", 3, GearItemSets.MACHETE);
        RecipeProvider.toolRecipes(recipeOutput, "spear", 1, GearItemSets.SPEAR);
        RecipeProvider.toolRecipes(recipeOutput, "trident", 3, GearItemSets.TRIDENT);
        RecipeProvider.maceRecipes(recipeOutput);
        RecipeProvider.toolRecipes(recipeOutput, "knife", 1, GearItemSets.KNIFE);
        RecipeProvider.toolRecipes(recipeOutput, "dagger", 1, GearItemSets.DAGGER);
        RecipeProvider.toolRecipes(recipeOutput, "pickaxe", 3, GearItemSets.PICKAXE);
        RecipeProvider.toolRecipes(recipeOutput, "shovel", 1, GearItemSets.SHOVEL);
        RecipeProvider.toolRecipes(recipeOutput, "axe", 3, GearItemSets.AXE);
        RecipeProvider.toolRecipes(recipeOutput, "paxel", 5, GearItemSets.PAXEL);
        RecipeProvider.toolRecipes(recipeOutput, "hammer", 6, GearItemSets.HAMMER);
        RecipeProvider.toolRecipes(recipeOutput, "excavator", 5, GearItemSets.EXCAVATOR);
        RecipeProvider.toolRecipes(recipeOutput, "hoe", 2, GearItemSets.HOE);
        RecipeProvider.toolRecipes(recipeOutput, "mattock", 4, GearItemSets.MATTOCK);
        RecipeProvider.toolRecipes(recipeOutput, "prospector_hammer", 2, GearItemSets.PROSPECTOR_HAMMER);
        RecipeProvider.toolRecipes(recipeOutput, "saw", 5, GearItemSets.SAW);
        RecipeProvider.toolRecipes(recipeOutput, "sickle", 3, GearItemSets.SICKLE);
        RecipeProvider.toolRecipes(recipeOutput, "shears", 2, GearItemSets.SHEARS);
        RecipeProvider.bowRecipes(recipeOutput, "fishing_rod", 2, GearItemSets.FISHING_ROD);
        RecipeProvider.bowRecipes(recipeOutput, "bow", 3, GearItemSets.BOW);
        RecipeProvider.bowRecipes(recipeOutput, "crossbow", 3, GearItemSets.CROSSBOW);
        RecipeProvider.bowRecipes(recipeOutput, "slingshot", 2, GearItemSets.SLINGSHOT);
        RecipeProvider.arrowRecipes(recipeOutput, "arrow", GearItemSets.ARROW);
        RecipeProvider.curioRecipes(recipeOutput, "ring", 2, GearItemSets.RING);
        RecipeProvider.curioRecipes(recipeOutput, "bracelet", 3, GearItemSets.BRACELET);
        RecipeProvider.curioRecipes(recipeOutput, "necklace", 3, GearItemSets.NECKLACE);
        RecipeProvider.armorRecipes(recipeOutput, 5, (GearItemSet<? extends GearArmorItem>)GearItemSets.HELMET);
        RecipeProvider.armorRecipes(recipeOutput, 8, (GearItemSet<? extends GearArmorItem>)GearItemSets.CHESTPLATE);
        RecipeProvider.armorRecipes(recipeOutput, 7, (GearItemSet<? extends GearArmorItem>)GearItemSets.LEGGINGS);
        RecipeProvider.armorRecipes(recipeOutput, 4, (GearItemSet<? extends GearArmorItem>)GearItemSets.BOOTS);
        RecipeProvider.shapelessPart(RecipeCategory.COMBAT, (ItemLike)GearItemSets.SHIELD.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of((GearItemSet)GearItemSets.SHIELD)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.SHIELD.get())).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), 2).save(recipeOutput, SilentGear.getId((String)"gear/shield_plate"));
        RecipeProvider.shapelessGear(RecipeCategory.COMBAT, (ItemLike)GearItemSets.SHIELD.gearItem()).requires((ICustomIngredient)BlueprintIngredient.of((GearItemSet)GearItemSets.SHIELD)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.SHIELD.get())).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), 2).requires((ICustomIngredient)GearPartIngredient.of((PartType)((PartType)PartTypes.ROD.get()))).save(recipeOutput, SilentGear.getId((String)"gear/shield_quick"));
        RecipeProvider.shapelessGear(RecipeCategory.TOOLS, (ItemLike)GearItemSets.SHIELD.gearItem()).requires((ICustomIngredient)BlueprintIngredient.of((GearItemSet)GearItemSets.SHIELD)).requires(Ingredient.of((ItemLike[])new ItemLike[]{SgItems.ALLOY_INGOT, SgItems.SUPER_ALLOY, SgItems.HYBRID_GEM}), 2).requires((ICustomIngredient)GearPartIngredient.of((PartType)((PartType)PartTypes.ROD.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)"gear/alloy_shield"));
        for (String material : new String[]{"iron", "golden", "diamond", "netherite"}) {
            for (String gear : new String[]{"axe", "boots", "chestplate", "helmet", "hoe", "leggings", "pickaxe", "shoves", "sword"}) {
                ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK).requires((ItemLike)Items.STICK).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.STICK), RecipeProvider.has((ItemLike)Items.STICK)).save(recipeOutput.withConditions(new ICondition[]{new NotCondition((ICondition)new ModLoadedCondition("sgearmetalworks"))}), ResourceLocation.fromNamespaceAndPath((String)"silentgear", (String)("gear/convert/" + material + "_" + gear)));
            }
        }
        RecipeProvider.shapedGear(RecipeCategory.COMBAT, (ItemLike)GearItemSets.SWORD.gearItem()).pattern("#").pattern("#").pattern("/").define(Character.valueOf('#'), (ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get())).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING})).define(Character.valueOf('/'), SgTags.Items.RODS_ROUGH).save(recipeOutput, SilentGear.getId((String)"gear/rough/sword"));
        RecipeProvider.shapedGear(RecipeCategory.COMBAT, (ItemLike)GearItemSets.DAGGER.gearItem()).pattern("#").pattern("/").define(Character.valueOf('#'), (ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get())).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING})).define(Character.valueOf('/'), SgTags.Items.RODS_ROUGH).save(recipeOutput, SilentGear.getId((String)"gear/rough/dagger"));
        RecipeProvider.shapedGear(RecipeCategory.COMBAT, (ItemLike)GearItemSets.KNIFE.gearItem()).pattern(" #").pattern("/ ").define(Character.valueOf('#'), (ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get())).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING})).define(Character.valueOf('/'), SgTags.Items.RODS_ROUGH).save(recipeOutput, SilentGear.getId((String)"gear/rough/knife"));
        RecipeProvider.shapedGear(RecipeCategory.TOOLS, (ItemLike)GearItemSets.PICKAXE.gearItem()).pattern("###").pattern(" / ").pattern(" / ").define(Character.valueOf('#'), (ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get())).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING})).define(Character.valueOf('/'), SgTags.Items.RODS_ROUGH).save(recipeOutput, SilentGear.getId((String)"gear/rough/pickaxe"));
        RecipeProvider.shapedGear(RecipeCategory.TOOLS, (ItemLike)GearItemSets.SHOVEL.gearItem()).pattern("#").pattern("/").pattern("/").define(Character.valueOf('#'), (ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get())).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING})).define(Character.valueOf('/'), SgTags.Items.RODS_ROUGH).save(recipeOutput, SilentGear.getId((String)"gear/rough/shovel"));
        RecipeProvider.shapedGear(RecipeCategory.TOOLS, (ItemLike)GearItemSets.AXE.gearItem()).pattern("##").pattern("#/").pattern(" /").define(Character.valueOf('#'), (ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get())).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING})).define(Character.valueOf('/'), SgTags.Items.RODS_ROUGH).save(recipeOutput, SilentGear.getId((String)"gear/rough/axe"));
    }

    private static ExtendedShapelessRecipeBuilder.Basic<ShapelessCompoundPartRecipe> compoundPart(DeferredItem<?> item, int count) {
        return new ExtendedShapelessRecipeBuilder.Basic(RecipeCategory.MISC, item.toStack(count), ShapelessCompoundPartRecipe::new);
    }

    private static void registerCompoundParts(RecipeOutput consumer) {
        RecipeProvider.compoundPart(SgItems.ROD, 4).requires((ICustomIngredient)BlueprintIngredient.of((Item)((PartBlueprintItem)SgItems.ROD_BLUEPRINT.get()))).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.ROD.get())).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), 2).save(consumer, SilentGear.getId((String)"part/rod"));
        RecipeProvider.compoundPart(SgItems.TIP, 1).requires((ICustomIngredient)BlueprintIngredient.of((Item)((PartBlueprintItem)SgItems.TIP_BLUEPRINT.get()))).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.TIP.get())).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING})).save(consumer, SilentGear.getId((String)"part/tip"));
        RecipeProvider.shapelessPart(RecipeCategory.TOOLS, (ItemLike)SgItems.ROD).requires((ICustomIngredient)BlueprintIngredient.of((Item)((PartBlueprintItem)SgItems.ROD_BLUEPRINT.get()))).requires(Ingredient.of((ItemLike[])new ItemLike[]{SgItems.ALLOY_INGOT, SgItems.SUPER_ALLOY, SgItems.HYBRID_GEM}), 2).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)"part/rod"));
        RecipeProvider.shapelessPart(RecipeCategory.TOOLS, (ItemLike)SgItems.TIP).requires((ICustomIngredient)BlueprintIngredient.of((Item)((PartBlueprintItem)SgItems.TIP_BLUEPRINT.get()))).requires(Ingredient.of((ItemLike[])new ItemLike[]{SgItems.ALLOY_INGOT, SgItems.SUPER_ALLOY, SgItems.HYBRID_GEM})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)"part/tip"));
    }

    private static void toolRecipes(RecipeOutput consumer, String name, int mainCount, GearItemSet<?> itemSet) {
        PartMaterialIngredient ingredient = PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get())).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING});
        RecipeProvider.shapelessPart(RecipeCategory.TOOLS, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ICustomIngredient)ingredient, mainCount).save(consumer, SilentGear.getId((String)("gear/" + name + "_head")));
        RecipeProvider.shapelessGear(RecipeCategory.TOOLS, (ItemLike)itemSet.gearItem()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ICustomIngredient)ingredient, mainCount).requires((ICustomIngredient)GearPartIngredient.of((PartType)((PartType)PartTypes.ROD.get()))).save(consumer, SilentGear.getId((String)("gear/" + name + "_quick")));
        RecipeProvider.shapelessPart(RecipeCategory.TOOLS, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires(Ingredient.of((ItemLike[])new ItemLike[]{SgItems.ALLOY_INGOT, SgItems.SUPER_ALLOY, SgItems.HYBRID_GEM}), mainCount).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)("gear/" + name + "_head")));
    }

    private static void maceRecipes(RecipeOutput output) {
        GearItemSet itemSet = GearItemSets.MACE;
        RecipeProvider.shapelessPart(RecipeCategory.TOOLS, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of((GearItemSet)itemSet)).requires((ItemLike)Items.HEAVY_CORE).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get())).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), 3).save(output, SilentGear.getId((String)"gear/mace_core"));
        RecipeProvider.shapelessGear(RecipeCategory.TOOLS, (ItemLike)itemSet.gearItem()).requires((ICustomIngredient)BlueprintIngredient.of((GearItemSet)itemSet)).requires((ItemLike)Items.HEAVY_CORE).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get())).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), 3).requires((ICustomIngredient)GearPartIngredient.of((PartType)((PartType)PartTypes.ROD.get()))).save(output, SilentGear.getId((String)"gear/mace_quick"));
        RecipeProvider.shapelessPart(RecipeCategory.TOOLS, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of((GearItemSet)itemSet)).requires((ItemLike)Items.HEAVY_CORE).requires(Ingredient.of((ItemLike[])new ItemLike[]{SgItems.ALLOY_INGOT, SgItems.SUPER_ALLOY, SgItems.HYBRID_GEM}), 3).save(output, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)"gear/mace_core"));
    }

    private static void bowRecipes(RecipeOutput consumer, String name, int mainCount, GearItemSet<?> itemSet) {
        RecipeProvider.shapelessPart(RecipeCategory.COMBAT, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get())).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), mainCount).save(consumer, SilentGear.getId((String)("gear/" + name + "_main")));
        RecipeProvider.shapelessGear(RecipeCategory.COMBAT, (ItemLike)itemSet.gearItem()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get())).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), mainCount).requires((ICustomIngredient)GearPartIngredient.of((PartType)((PartType)PartTypes.ROD.get()))).requires((ICustomIngredient)GearPartIngredient.of((PartType)((PartType)PartTypes.CORD.get()))).save(consumer, SilentGear.getId((String)("gear/" + name + "_quick")));
        RecipeProvider.shapelessPart(RecipeCategory.TOOLS, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires(Ingredient.of((ItemLike[])new ItemLike[]{SgItems.ALLOY_INGOT, SgItems.SUPER_ALLOY, SgItems.HYBRID_GEM}), mainCount).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)("gear/" + name + "_main")));
    }

    private static void arrowRecipes(RecipeOutput consumer, String name, GearItemSet<?> itemSet) {
        RecipeProvider.shapelessPart(RecipeCategory.COMBAT, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.PROJECTILE.get())).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING})).save(consumer, SilentGear.getId((String)("gear/" + name + "_head")));
        RecipeProvider.shapelessGear(RecipeCategory.COMBAT, (ItemLike)itemSet.gearItem()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.TOOL.get())).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING})).requires((ICustomIngredient)GearPartIngredient.of((PartType)((PartType)PartTypes.ROD.get()))).requires((ICustomIngredient)GearPartIngredient.of((PartType)((PartType)PartTypes.FLETCHING.get()))).save(consumer, SilentGear.getId((String)("gear/" + name + "_quick")));
        RecipeProvider.shapelessPart(RecipeCategory.TOOLS, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires(Ingredient.of((ItemLike[])new ItemLike[]{SgItems.ALLOY_INGOT, SgItems.SUPER_ALLOY, SgItems.HYBRID_GEM})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)("gear/" + name + "_head")));
    }

    private static void armorRecipes(RecipeOutput consumer, int mainCount, GearItemSet<? extends GearArmorItem> itemSet) {
        RecipeProvider.shapelessPart(RecipeCategory.COMBAT, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearArmorItem)itemSet.gearItem()).getGearType()).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), mainCount).save(consumer, SilentGear.getId((String)("gear/" + NameUtils.fromItem((ItemLike)itemSet.mainPart()).getPath())));
        RecipeProvider.shapelessPart(RecipeCategory.TOOLS, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires(Ingredient.of((ItemLike[])new ItemLike[]{SgItems.ALLOY_INGOT, SgItems.SUPER_ALLOY, SgItems.HYBRID_GEM}), mainCount).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)("gear/" + NameUtils.fromItem((ItemLike)itemSet.mainPart()).getPath() + "_head")));
    }

    private static void curioRecipes(RecipeOutput consumer, String name, int mainCount, GearItemSet<?> itemSet) {
        RecipeProvider.shapelessPart(RecipeCategory.MISC, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.CURIO.get()), (IMaterialCategory[])new IMaterialCategory[]{MaterialCategories.METAL, CastingMaterialCategories.CRUDE}).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), mainCount).save(consumer, SilentGear.getId((String)("gear/" + name + "_main_only")));
        RecipeProvider.shapelessGear(RecipeCategory.MISC, (ItemLike)itemSet.gearItem()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires((ICustomIngredient)PartMaterialIngredient.of((PartType)((PartType)PartTypes.MAIN.get()), (GearType)((GearType)GearTypes.CURIO.get()), (IMaterialCategory[])new IMaterialCategory[]{MaterialCategories.METAL, CastingMaterialCategories.CRUDE}).not(new IMaterialCategory[]{CastingMaterialCategories.CASTING}).not(new IMaterialCategory[]{CastingMaterialCategories.INFUSING}), mainCount).requires((ICustomIngredient)GearPartIngredient.of((PartType)((PartType)PartTypes.SETTING.get()))).save(consumer, SilentGear.getId((String)("gear/" + name + "_quick")));
        RecipeProvider.shapelessPart(RecipeCategory.TOOLS, (ItemLike)itemSet.mainPart()).requires((ICustomIngredient)BlueprintIngredient.of(itemSet)).requires(Ingredient.of((ItemLike[])new ItemLike[]{SgItems.ALLOY_INGOT, SgItems.SUPER_ALLOY, SgItems.HYBRID_GEM}), mainCount).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)("gear/" + name + "_main_only")));
    }

    private static ExtendedShapedRecipeBuilder.Basic<ShapedGearRecipe> shapedGear(RecipeCategory category, ItemLike item) {
        return new ExtendedShapedRecipeBuilder.Basic(category, new ItemStack(item), ShapedGearRecipe::new);
    }

    private static ExtendedShapelessRecipeBuilder.Basic<ShapelessCompoundPartRecipe> shapelessPart(RecipeCategory category, ItemLike item) {
        return new ExtendedShapelessRecipeBuilder.Basic(category, new ItemStack(item), ShapelessCompoundPartRecipe::new);
    }

    private static ExtendedShapelessRecipeBuilder.Basic<ShapelessGearRecipe> shapelessGear(RecipeCategory category, ItemLike item) {
        return new ExtendedShapelessRecipeBuilder.Basic(category, new ItemStack(item), ShapelessGearRecipe::new);
    }

    private static void alloyRecipe(List<SizedFluidIngredient> inputs, int speed, FluidStack output, RecipeOutput recipeOutput) {
        RecipeProvider.alloyRecipe(inputs, speed, output, recipeOutput, "alloying/" + BuiltInRegistries.FLUID.getKey((Object)output.getFluid()).getPath());
    }

    private static void alloyRecipe(List<SizedFluidIngredient> inputs, int speed, FluidStack output, RecipeOutput recipeOutput, String recipeId) {
        RecipeOutput conditionalRecipeOutput = recipeOutput;
        for (SizedFluidIngredient sizedFluidIngredient : inputs) {
            FluidIngredient fluidIngredient = sizedFluidIngredient.ingredient();
            if (!(fluidIngredient instanceof TagFluidIngredient)) continue;
            TagFluidIngredient tagFluidIngredient = (TagFluidIngredient)fluidIngredient;
            conditionalRecipeOutput = conditionalRecipeOutput.withConditions(new ICondition[]{new NotCondition((ICondition)new FluidTagEmptyCondition(tagFluidIngredient.tag()))});
        }
        FluidAlloyingRecipeBuilder.of(inputs, (int)speed, (FluidStack)output).save(conditionalRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)recipeId));
    }

    private void georeCompat(RecipeOutput recipeOutput) {
        for (String resource : new String[]{"ruby", "topaz", "sapphire"}) {
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)("molten_" + (resource.equals("coal") ? "carbon" : resource))));
            Item shardItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"geore", (String)(resource + "_shard")));
            Item blockItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"geore", (String)(resource + "_block")));
            ItemMeltingRecipeBuilder.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{blockItem}), (FluidStack)new FluidStack(fluid, 400)).save(recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("geore")}).withConditions(new ICondition[]{new ModLoadedCondition("silentgems")}), ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)("melting/geore/" + resource + "_block")));
            ItemMeltingRecipeBuilder.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{shardItem}), (FluidStack)new FluidStack(fluid, 100)).save(recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("geore")}).withConditions(new ICondition[]{new ModLoadedCondition("silentgems")}), ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)("melting/geore/" + resource + "_shard")));
        }
    }

    private static void atmCompat(RecipeOutput recipeOutput, GearItemSet<?> gearItemSet, Pair<PartMaterialIngredient, Integer> amount) {
        if (!gearItemSet.partName().equals("elytra_wings")) {
            ItemStack cast = gearItemSet.mainPart().getDefaultInstance();
            ItemStack output = gearItemSet.mainPart().getDefaultInstance();
            JsonElement inputMaterial = JsonParser.parseString((String)"{\"item\": {\"count\": 1, \"id\": \"silentgear:tyrian_steel_ingot\"}, \"material\": \"silentgear:tyrian_steel\"}");
            JsonElement uruMaterial = JsonParser.parseString((String)"{\"item\": {\"count\": 1, \"id\": \"sgearmetalworks:uru_metal_ingot\"}, \"material\": \"sgearmetalworks:uru_metal\"}");
            MaterialInstance INPUT_MATERIAL = (MaterialInstance)((Pair)MaterialInstance.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)inputMaterial).getOrThrow()).getFirst();
            MaterialInstance URU_MATERIAL = (MaterialInstance)((Pair)MaterialInstance.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)uruMaterial).getOrThrow()).getFirst();
            ArrayList<MaterialInstance> ingredientMats = new ArrayList<MaterialInstance>();
            ArrayList<MaterialInstance> outputMats = new ArrayList<MaterialInstance>();
            for (int i = 0; i < (Integer)amount.getSecond(); ++i) {
                ingredientMats.add(INPUT_MATERIAL);
                outputMats.add(URU_MATERIAL);
            }
            cast.set(SgDataComponents.MATERIAL_LIST, ingredientMats);
            output.set(SgDataComponents.MATERIAL_LIST, outputMats);
            ItemCastingRecipeBuilder.of((Ingredient)GearComponentIngredient.of(cast), (SizedFluidIngredient)SizedFluidIngredient.of(ModTags.Fluids.MOLTEN_URU_METAL, (int)(90 * (Integer)amount.getSecond())), (ItemStack)output, (boolean)true).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"sgearmetalworks", (String)("casting/uru/" + gearItemSet.partName())));
        }
    }
}

