/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.init.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemPartType;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class DropPartModifier
extends LootModifier {
    public static final MapCodec<DropPartModifier> CODEC = RecordCodecBuilder.mapCodec(i -> LootModifier.codecStart((RecordCodecBuilder.Instance)i).and((App)ResourceLocation.CODEC.fieldOf("material").forGetter(e -> e.material)).apply((Applicative)i, DropPartModifier::new));
    private final ResourceLocation material;

    protected DropPartModifier(LootItemCondition[] conditionsIn, ResourceLocation material) {
        super(conditionsIn);
        this.material = material;
    }

    protected DropPartModifier(ResourceLocation material, LootItemCondition ... conditionsIn) {
        super(conditionsIn);
        this.material = material;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> loot, LootContext ctx) {
        MetalGolemPartType type = MetalGolemPartType.values()[ctx.getRandom().nextInt(4)];
        loot.add((Object)GolemPart.setMaterial(type.toItem().getDefaultInstance(), this.material));
        return loot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

