/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.init;

import com.tterrag.registrate.providers.DataProviderInitializer;
import com.tterrag.registrate.providers.ProviderType;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2core.compat.patchouli.PatchouliHelper;
import dev.xkmc.l2core.init.L2TagGen;
import dev.xkmc.l2core.init.reg.ench.EnchReg;
import dev.xkmc.l2core.init.reg.registrate.L2Registrate;
import dev.xkmc.l2core.init.reg.simple.Reg;
import dev.xkmc.l2core.serial.config.ConfigTypeEntry;
import dev.xkmc.l2core.serial.config.PacketHandlerWithConfig;
import dev.xkmc.l2damagetracker.contents.attack.AttackEventHandler;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2serial.network.PacketHandler;
import dev.xkmc.modulargolems.compat.curio.CurioCompatRegistry;
import dev.xkmc.modulargolems.compat.materials.common.CompatManager;
import dev.xkmc.modulargolems.compat.misc.CEICompat;
import dev.xkmc.modulargolems.content.capability.ConfigHeartBeatToServer;
import dev.xkmc.modulargolems.content.capability.ConfigSyncToClient;
import dev.xkmc.modulargolems.content.capability.ConfigUpdateToServer;
import dev.xkmc.modulargolems.content.capability.TrackerDeleteToServer;
import dev.xkmc.modulargolems.content.capability.TrackerHeartBeatToServer;
import dev.xkmc.modulargolems.content.capability.TrackerSyncToClient;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.config.GolemPartConfig;
import dev.xkmc.modulargolems.content.entity.common.ReforgeUpdatePacket;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.GolemWeaponRegistry;
import dev.xkmc.modulargolems.content.entity.mode.GolemModes;
import dev.xkmc.modulargolems.content.menu.ghost.SetItemFilterToServer;
import dev.xkmc.modulargolems.content.menu.registry.GolemTabRegistry;
import dev.xkmc.modulargolems.content.menu.registry.OpenConfigMenuToServer;
import dev.xkmc.modulargolems.content.menu.registry.OpenEquipmentMenuToServer;
import dev.xkmc.modulargolems.events.GolemAttackListener;
import dev.xkmc.modulargolems.events.GolemDispenserBehaviors;
import dev.xkmc.modulargolems.init.advancement.GolemTriggers;
import dev.xkmc.modulargolems.init.data.MGAdvGen;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.data.MGConfigGen;
import dev.xkmc.modulargolems.init.data.MGDataMapGen;
import dev.xkmc.modulargolems.init.data.MGLangData;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.data.RecipeGen;
import dev.xkmc.modulargolems.init.data.SlotGen;
import dev.xkmc.modulargolems.init.loot.MGGLMGen;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import dev.xkmc.modulargolems.init.registrate.GolemMiscs;
import dev.xkmc.modulargolems.init.registrate.GolemModifiers;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="modulargolems")
@EventBusSubscriber(modid="modulargolems", bus=EventBusSubscriber.Bus.MOD)
public class ModularGolems {
    public static final String MODID = "modulargolems";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Reg REG = new Reg("modulargolems");
    public static final L2Registrate REGISTRATE = new L2Registrate("modulargolems");
    public static final PacketHandlerWithConfig HANDLER = new PacketHandlerWithConfig("modulargolems", 1, new Function[]{e -> e.create(ConfigSyncToClient.class, PacketHandler.NetDir.PLAY_TO_CLIENT), e -> e.create(ConfigUpdateToServer.class, PacketHandler.NetDir.PLAY_TO_SERVER), e -> e.create(ConfigHeartBeatToServer.class, PacketHandler.NetDir.PLAY_TO_SERVER), e -> e.create(SetItemFilterToServer.class, PacketHandler.NetDir.PLAY_TO_SERVER), e -> e.create(OpenConfigMenuToServer.class, PacketHandler.NetDir.PLAY_TO_SERVER), e -> e.create(OpenEquipmentMenuToServer.class, PacketHandler.NetDir.PLAY_TO_SERVER), e -> e.create(TrackerSyncToClient.class, PacketHandler.NetDir.PLAY_TO_CLIENT), e -> e.create(TrackerHeartBeatToServer.class, PacketHandler.NetDir.PLAY_TO_SERVER), e -> e.create(TrackerDeleteToServer.class, PacketHandler.NetDir.PLAY_TO_SERVER), e -> e.create(ReforgeUpdatePacket.class, PacketHandler.NetDir.PLAY_TO_CLIENT)});
    public static final ConfigTypeEntry<GolemPartConfig> PARTS = new ConfigTypeEntry(HANDLER, "parts", GolemPartConfig.class);
    public static final ConfigTypeEntry<GolemMaterialConfig> MATERIALS = new ConfigTypeEntry(HANDLER, "materials", GolemMaterialConfig.class);

    public ModularGolems() {
        GolemItems.register();
        GolemTypes.register();
        GolemMiscs.register();
        GolemModifiers.register();
        GolemTabRegistry.register();
        MGConfig.init();
        GolemTriggers.register();
        GolemModes.register();
        CurioCompatRegistry.register();
        AttackEventHandler.register((int)3500, (AttackListener)new GolemAttackListener());
        if (ModList.get().isLoaded("patchouli")) {
            new PatchouliHelper(REGISTRATE, "golem_guide").buildModel().buildShapelessRecipe(e -> e.requires((ItemLike)Items.BOOK).requires(GolemItems.GOLEM_TEMPLATE), () -> Items.BOOK).buildBook("Modular Golem Guide", "Welcome to Tinker-like golem assembly and upgrade mod", 1, GolemItems.ITEMS.key());
        }
        if (ModList.get().isLoaded("create_enchantment_industry")) {
            CEICompat.register();
        }
    }

    public static ResourceLocation loc(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)id);
    }

    @SubscribeEvent
    public static void modifyAttributes(EntityAttributeModificationEvent event) {
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            GolemWeaponRegistry.init();
            GolemDispenserBehaviors.registerDispenseBehaviors();
            CompatManager.commonSetup();
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void gatherData(GatherDataEvent event) {
        REGISTRATE.addDataGenerator(ProviderType.LANG, MGLangData::genLang);
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, RecipeGen::genRecipe);
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, MGTagGen::onBlockTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, MGTagGen::onItemTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ENTITY_TAGS, MGTagGen::onEntityTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ADVANCEMENT, MGAdvGen::genAdvancements);
        REGISTRATE.addDataGenerator(ProviderType.DATA_MAP, MGDataMapGen::genDataMap);
        DataGenerator gen = event.getGenerator();
        CompletableFuture pvd = event.getLookupProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new MGConfigGen(gen, pvd));
        CompatManager.gatherData(event);
        gen.addProvider(event.includeServer(), (DataProvider)new SlotGen(gen.getPackOutput(), event.getExistingFileHelper(), pvd));
        gen.addProvider(event.includeServer(), (DataProvider)new MGGLMGen(gen.getPackOutput(), pvd, MODID));
        DataProviderInitializer init = REGISTRATE.getDataGenInitializer();
        if (ModList.get().isLoaded("l2complements")) {
            REGISTRATE.addDataGenerator(L2TagGen.EFF_TAGS, MGTagGen::onEffTagGen);
            init.add(Registries.ENCHANTMENT, arg_0 -> ((EnchReg)LCEnchantments.REG).build(arg_0));
        }
        init.addDependency(L2TagGen.ENCH_TAGS, ProviderType.DYNAMIC);
        init.addDependency(ProviderType.RECIPE, L2TagGen.ENCH_TAGS);
    }
}

