/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.init;

import dev.xkmc.modulargolems.compat.curio.CurioCompatRegistry;
import dev.xkmc.modulargolems.compat.maid.MaidSkinCompat;
import dev.xkmc.modulargolems.compat.materials.common.CompatManager;
import dev.xkmc.modulargolems.content.client.armor.GolemEquipmentModels;
import dev.xkmc.modulargolems.content.client.overlay.GolemStatusOverlay;
import dev.xkmc.modulargolems.content.entity.humanoid.skin.PlayerSkinRenderer;
import dev.xkmc.modulargolems.content.item.golem.GolemBEWLR;
import dev.xkmc.modulargolems.content.item.upgrade.UpgradeItem;
import dev.xkmc.modulargolems.content.menu.registry.GolemTabRegistry;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;

@EventBusSubscriber(value={Dist.CLIENT}, modid="modulargolems", bus=EventBusSubscriber.Bus.MOD)
public class GolemClient {
    private static final boolean ENABLE_TLM = true;

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        if (ModList.get().isLoaded("touhou_little_maid")) {
            NeoForge.EVENT_BUS.register(MaidSkinCompat.class);
        }
        event.enqueueWork(() -> {
            ClampedItemPropertyFunction func = (stack, level, entity, layer) -> entity != null && entity.isBlocking() && entity.getUseItem() == stack ? 1.0f : 0.0f;
            ItemProperties.register((Item)Items.SHIELD, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"blocking"), (ItemPropertyFunction)func);
            ClampedItemPropertyFunction arrow = (stack, level, entity, layer) -> stack.is(MGTagGen.BLUE_UPGRADES) ? 1.0f : (stack.is(MGTagGen.POTION_UPGRADES) ? 0.5f : 0.0f);
            for (UpgradeItem item : UpgradeItem.LIST) {
                ItemProperties.register((Item)item, (ResourceLocation)ModularGolems.loc("blue_arrow"), (ItemPropertyFunction)arrow);
            }
            CompatManager.dispatchClientSetup();
            GolemTabRegistry.register();
            CurioCompatRegistry.clientRegister();
        });
    }

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, ModularGolems.loc("golem_stats"), (LayeredDraw.Layer)new GolemStatusOverlay());
    }

    @SubscribeEvent
    public static void registerArmorLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        GolemEquipmentModels.registerArmorLayer(event);
    }

    @SubscribeEvent
    public static void onResourceReload(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)GolemBEWLR.INSTANCE.get());
    }

    @SubscribeEvent
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        PlayerSkinRenderer.SLIM = new PlayerSkinRenderer(event.getContext(), true);
        PlayerSkinRenderer.REGULAR = new PlayerSkinRenderer(event.getContext(), false);
        if (ModList.get().isLoaded("touhou_little_maid")) {
            MaidSkinCompat.addLayers(event);
        }
    }
}

