/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.events;

import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.content.item.card.ClickEntityFilterCard;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemModifiers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;

@EventBusSubscriber(modid="modulargolems", bus=EventBusSubscriber.Bus.GAME)
public class ModifierEventListeners {
    @SubscribeEvent
    public static void onGolemSpawn(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof AbstractGolemEntity) {
            AbstractGolemEntity entity2 = (AbstractGolemEntity)entity;
            entity2.getModifiers().forEach((k, v) -> k.onGolemSpawn(entity2, (int)v));
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        for (Entity e : event.getAffectedEntities()) {
            AbstractGolemEntity golem;
            if (!(e instanceof AbstractGolemEntity) || (golem = (AbstractGolemEntity)e).getModifiers().getOrDefault(GolemModifiers.EXPLOSION_RES.get(), 0) <= 0) continue;
            event.getAffectedBlocks().clear();
            return;
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (!((Boolean)MGConfig.COMMON.doEnemyAggro.get()).booleanValue()) {
            return;
        }
        if (!(mob instanceof Enemy) || mob instanceof Creeper) {
            return;
        }
        int priority = 0;
        NearestAttackableTargetGoal ans = null;
        for (WrappedGoal goal : mob.targetSelector.getAvailableGoals()) {
            Goal goal2 = goal.getGoal();
            if (!(goal2 instanceof NearestAttackableTargetGoal)) continue;
            NearestAttackableTargetGoal target = (NearestAttackableTargetGoal)goal2;
            if (target.targetType != IronGolem.class) continue;
            priority = goal.getPriority();
            ans = new NearestAttackableTargetGoal(mob, AbstractGolemEntity.class, target.randomInterval, target.mustSee, target.mustReach, e -> {
                AbstractGolemEntity golem;
                return e instanceof AbstractGolemEntity && !(golem = (AbstractGolemEntity)((Object)e)).isHostile();
            });
            break;
        }
        if (ans != null) {
            mob.targetSelector.addGoal(priority, ans);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDrop(LivingDropsEvent event) {
        AbstractGolemEntity e;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof AbstractGolemEntity && (e = (AbstractGolemEntity)entity).hasFlag(GolemFlags.PICKUP)) {
            event.getDrops().forEach(x -> x.moveTo(e.position()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onTargetCardClick(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        if (stack.getItem() instanceof ClickEntityFilterCard) {
            Entity entity = event.getTarget();
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                event.setCancellationResult(event.getItemStack().interactLivingEntity(event.getEntity(), le, event.getHand()));
                event.setCanceled(true);
            }
        } else {
            Entity entity = event.getTarget();
            if (entity instanceof AbstractGolemEntity) {
                AbstractGolemEntity golem = (AbstractGolemEntity)entity;
                if (stack.is(MGTagGen.MODIFYING_ITEM) && !golem.canModify(event.getEntity())) {
                    event.setCancellationResult(InteractionResult.FAIL);
                    event.setCanceled(true);
                }
            }
        }
    }
}

