/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.events;

import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import dev.xkmc.modulargolems.content.item.equipments.MetalGolemArmorItem;
import dev.xkmc.modulargolems.content.item.equipments.MetalGolemBeaconItem;
import dev.xkmc.modulargolems.content.item.equipments.MetalGolemWeaponItem;
import dev.xkmc.modulargolems.events.event.GolemEquipItemEvent;
import dev.xkmc.modulargolems.events.event.GolemThrowableEvent;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber(modid="modulargolems", bus=EventBusSubscriber.Bus.GAME)
public class GolemEventListeners {
    @SubscribeEvent
    public static void onEquip(GolemEquipItemEvent event) {
        AbstractGolemEntity<?, ?> golem = event.getEntity();
        ItemStack stack = event.getStack();
        if (golem instanceof HumanoidGolemEntity) {
            EquipmentSlot slot;
            if (stack.getItem() instanceof ArrowItem) {
                event.setSlot(stack.getCount(), EquipmentSlot.OFFHAND);
            }
            if (stack.getItem() instanceof BowItem) {
                event.setSlot(1, EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND);
            }
            if (stack.getItem() instanceof BannerItem) {
                event.setSlot(1, EquipmentSlot.HEAD);
            }
            if (stack.canEquip(slot = golem.getEquipmentSlotForItem(stack), golem)) {
                if (slot == EquipmentSlot.MAINHAND) {
                    event.setSlot(1, EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND);
                } else {
                    event.setSlot(1, slot);
                }
            }
        }
        if (golem instanceof MetalGolemEntity) {
            Item item = stack.getItem();
            if (item instanceof MetalGolemArmorItem) {
                MetalGolemArmorItem mgai = (MetalGolemArmorItem)item;
                event.setSlot(1, mgai.getSlot());
            } else if (stack.getItem() instanceof MetalGolemBeaconItem) {
                event.setSlot(1, EquipmentSlot.FEET);
            } else if (stack.getItem() instanceof MetalGolemWeaponItem || stack.is(MGTagGen.LARGE_GOLEM_WEAPONS)) {
                event.setSlot(1, EquipmentSlot.MAINHAND);
            } else if (stack.getItem() instanceof BannerItem) {
                event.setSlot(1, EquipmentSlot.HEAD, EquipmentSlot.FEET);
            }
        }
        if (golem instanceof DogGolemEntity && stack.getItem() instanceof BannerItem) {
            event.setSlot(1, EquipmentSlot.HEAD);
        }
    }

    @SubscribeEvent
    public static void isThrowable(GolemThrowableEvent event) {
        if (event.getStack().getItem() instanceof TridentItem) {
            event.setThrowable(level -> {
                ThrownTrident ans = new ThrownTrident(level, (LivingEntity)event.getEntity(), event.getStack());
                ans.pickup = AbstractArrow.Pickup.DISALLOWED;
                return ans;
            });
        }
    }
}

