/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.events;

import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.ModularGolems;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class GolemAttackListener
implements AttackListener {
    private static final ResourceLocation WEAPON_INHERENT = ModularGolems.loc("weapon_inherent");

    public void onCreateSource(CreateSourceEvent event) {
        LivingEntity livingEntity = event.getAttacker();
        if (livingEntity instanceof AbstractGolemEntity) {
            AbstractGolemEntity golem = (AbstractGolemEntity)livingEntity;
            for (Map.Entry entry : golem.getModifiers().entrySet()) {
                ((GolemModifier)((Object)entry.getKey())).modifySource(golem, event, (Integer)entry.getValue());
            }
        }
    }

    public boolean onAttack(DamageData.Attack data) {
        AbstractGolemEntity golem;
        Object object = data.getAttacker();
        if (object instanceof AbstractGolemEntity && !(golem = (AbstractGolemEntity)((Object)object)).canAttack(data.getTarget())) {
            return true;
        }
        object = data.getTarget();
        if (object instanceof AbstractGolemEntity) {
            golem = (AbstractGolemEntity)((Object)object);
            if (data.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                return false;
            }
            for (Map.Entry entry : golem.getModifiers().entrySet()) {
                if (!((GolemModifier)((Object)entry.getKey())).onAttacked(golem, data, (Integer)entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public void onHurt(DamageData.Offence data) {
        LivingEntity livingEntity = data.getAttacker();
        if (livingEntity instanceof AbstractGolemEntity) {
            AbstractGolemEntity golem = (AbstractGolemEntity)livingEntity;
            data.addHurtModifier(DamageModifier.nonlinearPre((int)-1000, dmg -> dmg + golem.getMainHandItem().getItem().getAttackDamageBonus((Entity)data.getTarget(), dmg, data.getSource()), (ResourceLocation)WEAPON_INHERENT));
            for (Map.Entry entry : golem.getModifiers().entrySet()) {
                ((GolemModifier)((Object)entry.getKey())).onHurtTarget(golem, data, (Integer)entry.getValue());
            }
        }
    }

    public void onHurtMaximized(DamageData.OffenceMax data) {
    }

    public void onDamage(DamageData.Defence data) {
        LivingEntity livingEntity = data.getTarget();
        if (livingEntity instanceof AbstractGolemEntity) {
            AbstractGolemEntity golem = (AbstractGolemEntity)livingEntity;
            if (data.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                return;
            }
            for (Map.Entry entry : golem.getModifiers().entrySet()) {
                ((GolemModifier)((Object)entry.getKey())).onDamaged(golem, data, (Integer)entry.getValue());
            }
        }
    }

    public void onDamageFinalized(DamageData.DefenceMax data) {
        AbstractGolemEntity golem;
        Object object = data.getAttacker();
        if (object instanceof AbstractGolemEntity) {
            golem = (AbstractGolemEntity)((Object)object);
            object = golem.getModifiers().entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                ((GolemModifier)((Object)entry.getKey())).postHurtTarget(golem, data, (Integer)entry.getValue());
            }
            Player owner = golem.getOwner();
            if (owner != null) {
                data.getTarget().setLastHurtByPlayer(owner);
            }
        }
        if ((object = data.getTarget()) instanceof AbstractGolemEntity) {
            golem = (AbstractGolemEntity)((Object)object);
            for (Map.Entry entry : golem.getModifiers().entrySet()) {
                ((GolemModifier)((Object)entry.getKey())).postDamaged(golem, data, (Integer)entry.getValue());
            }
        }
    }
}

