/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.events;

import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.core.GolemType;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.item.data.GolemUpgrade;
import dev.xkmc.modulargolems.content.item.golem.GolemFacade;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.content.item.upgrade.AddSlotItem;
import dev.xkmc.modulargolems.content.item.upgrade.UpgradeItem;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.content.modifier.base.ModifierInstance;
import dev.xkmc.modulargolems.init.advancement.GolemAnvilFixTrigger;
import dev.xkmc.modulargolems.init.advancement.GolemTriggers;
import dev.xkmc.modulargolems.init.advancement.PartCraftTrigger;
import dev.xkmc.modulargolems.init.advancement.UpgradeApplyTrigger;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.GrindstoneEvent;
import net.neoforged.neoforge.event.entity.player.AnvilRepairEvent;

@EventBusSubscriber(modid="modulargolems", bus=EventBusSubscriber.Bus.GAME)
public class CraftEventListeners {
    @SubscribeEvent
    public static void onAnvilCraft(AnvilUpdateEvent event) {
        Object mat;
        ItemStack stack = event.getLeft();
        ItemStack block = event.getRight();
        Item item = stack.getItem();
        if (item instanceof GolemPart) {
            GolemPart part = (GolemPart)item;
            if (part.count <= block.getCount()) {
                if (block.is(MGTagGen.SPECIAL_CRAFT)) {
                    return;
                }
                mat = GolemMaterial.getMaterial(block);
                if (((Optional)mat).isPresent()) {
                    ItemStack new_stack = stack.copy();
                    GolemPart.setMaterial(new_stack, (ResourceLocation)((Optional)mat).get());
                    event.setOutput(new_stack);
                    event.setMaterialCost(part.count);
                    event.setCost(1L);
                }
            }
        }
        if ((mat = stack.getItem()) instanceof GolemHolder) {
            GolemHolder holder = (GolemHolder)((Object)mat);
            Item item2 = block.getItem();
            if (item2 instanceof AddSlotItem) {
                AddSlotItem item3 = (AddSlotItem)item2;
                CraftEventListeners.addSlot(event, holder, item3.slot);
            } else {
                item2 = block.getItem();
                if (item2 instanceof UpgradeItem) {
                    UpgradeItem upgrade = (UpgradeItem)item2;
                    CraftEventListeners.appendUpgrade(event, holder, upgrade);
                } else {
                    CraftEventListeners.fixGolem(event, holder, stack);
                }
            }
        }
        if (stack.is(GolemItems.EMPTY_UPGRADE)) {
            Optional<ResourceLocation> mat2 = GolemMaterial.getRepairMaterial(block);
            if (mat2.isEmpty()) {
                return;
            }
            ItemStack ans = GolemFacade.setMaterial(GolemItems.FACADE.asStack(), mat2.get());
            ans.setCount(stack.getCount());
            int consume = Math.min(stack.getCount(), block.getCount());
            event.setOutput(ans);
            event.setMaterialCost(consume);
            event.setCost((long)(stack.getCount() - consume + 1));
        }
    }

    @SubscribeEvent
    public static void onAnvilFinish(AnvilRepairEvent event) {
        Object mat;
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        ItemStack stack = event.getLeft();
        ItemStack block = event.getRight();
        Item item = stack.getItem();
        if (item instanceof GolemPart) {
            GolemPart part = (GolemPart)item;
            if (part.count <= block.getCount()) {
                mat = GolemMaterial.getMaterial(block);
                ((Optional)mat).ifPresent(rl -> ((PartCraftTrigger)((Object)((Object)GolemTriggers.PART_CRAFT.get()))).trigger((ServerPlayer)event.getEntity(), (ResourceLocation)rl));
            }
        }
        if ((mat = stack.getItem()) instanceof GolemHolder) {
            GolemHolder holder = (GolemHolder)((Object)mat);
            if (block.getItem() instanceof UpgradeItem) {
                ItemStack result = event.getOutput();
                ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(result);
                GolemUpgrade upgrades = GolemHolder.getUpgrades(result);
                int remaining = holder.getRemaining(mats, upgrades);
                int total = upgrades.size();
                ((UpgradeApplyTrigger)((Object)GolemTriggers.UPGRADE_APPLY.get())).trigger((ServerPlayer)event.getEntity(), block, remaining, total);
            } else {
                ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(stack);
                GolemType type = holder.getEntityType();
                Object part = type.getBodyPart();
                if (mats.size() <= part.ordinal()) {
                    return;
                }
                GolemMaterial mat2 = mats.get(part.ordinal());
                Ingredient ing = GolemMaterialConfig.get().getRepairIngredient(mat2.id());
                if (!ing.test(block)) {
                    return;
                }
                ((GolemAnvilFixTrigger)((Object)GolemTriggers.ANVIL_FIX.get())).trigger((ServerPlayer)event.getEntity(), mat2.id());
            }
        }
    }

    @SubscribeEvent
    public static void onGrindStone(GrindstoneEvent.OnPlaceItem event) {
        ItemStack copy;
        if (event.getTopItem().getItem() instanceof GolemHolder && GolemHolder.getUpgrades(copy = event.getTopItem().copy()).size() > 0) {
            GolemUpgrade.removeAll(copy);
            event.setOutput(copy);
            event.setXp(0);
        }
    }

    private static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> void fixGolem(AnvilUpdateEvent event, GolemHolder<T, P> holder, ItemStack stack) {
        CustomData data = (CustomData)GolemItems.ENTITY.get(stack);
        if (data == null) {
            return;
        }
        Ingredient ing = GolemHolder.getHealingMaterial(stack);
        if (ing == null || ing.isEmpty()) {
            return;
        }
        ItemStack repairStack = event.getRight();
        if (!ing.test(repairStack)) {
            return;
        }
        int reforge = GolemHolder.getReforge(stack);
        if (reforge > 0) {
            if (repairStack.getCount() <= reforge) {
                ItemStack result = stack.copy();
                GolemHolder.setReforge(result, reforge - repairStack.getCount());
                event.setMaterialCost(repairStack.getCount());
                event.setCost(1L);
                event.setOutput(result);
            } else {
                ItemStack result = stack.copy();
                GolemHolder.setReforge(result, 0);
                float max = GolemHolder.getMaxHealth(result);
                float health = GolemHolder.getHealth(stack);
                int maxFix = Math.min(repairStack.getCount() - reforge, (int)Math.ceil((max - health) / max * 4.0f));
                event.setMaterialCost(maxFix + reforge);
                event.setCost((long)(reforge + maxFix));
                GolemHolder.setHealth(result, Math.min(max, health + max / 4.0f * (float)maxFix));
                event.setOutput(result);
            }
        } else {
            float max = GolemHolder.getMaxHealth(stack);
            float health = GolemHolder.getHealth(stack);
            if (health >= max) {
                return;
            }
            int maxFix = Math.min(repairStack.getCount(), (int)Math.ceil((max - health) / max * 4.0f));
            event.setMaterialCost(maxFix);
            event.setCost((long)maxFix);
            ItemStack result = stack.copy();
            GolemHolder.setHealth(result, Math.min(max, health + max / 4.0f * (float)maxFix));
            event.setOutput(result);
        }
    }

    private static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> void addSlot(AnvilUpdateEvent event, GolemHolder<T, P> holder, int slot) {
        ItemStack stack = event.getLeft();
        ItemStack result = stack.copy();
        GolemUpgrade.addSlot(result, slot);
        event.setOutput(result);
        event.setCost(1L);
        event.setMaterialCost(1);
    }

    private static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> void appendUpgrade(AnvilUpdateEvent event, GolemHolder<T, P> holder, UpgradeItem upgrade) {
        ItemStack stack = event.getLeft();
        GolemUpgrade upgrades = GolemHolder.getUpgrades(stack);
        ItemStack result = CraftEventListeners.appendUpgrade(stack, holder, upgrade);
        if (result.isEmpty()) {
            return;
        }
        event.setOutput(result);
        event.setCost((long)Math.min(39, 4 * (1 + upgrades.size())));
        event.setMaterialCost(1);
    }

    public static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> ItemStack appendUpgrade(ItemStack stack, GolemHolder<T, P> holder, UpgradeItem upgrade) {
        if (!upgrade.fitsOn(holder.getEntityType())) {
            return ItemStack.EMPTY;
        }
        ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(stack);
        GolemUpgrade upgrades = GolemHolder.getUpgrades(stack);
        ArrayList<Item> copy = new ArrayList<Item>(upgrades.upgrades());
        copy.add(upgrade);
        int remaining = holder.getRemaining(mats, new GolemUpgrade(upgrades.extraSlot(), copy));
        if (remaining < 0) {
            return ItemStack.EMPTY;
        }
        HashMap<GolemModifier, Integer> map = GolemMaterial.collectModifiers(GolemHolder.getMaterial(stack), upgrades);
        for (ModifierInstance e : upgrade.get()) {
            if (map.getOrDefault((Object)e.mod(), 0) < e.mod().maxLevel) continue;
            return ItemStack.EMPTY;
        }
        ItemStack result = stack.copy();
        GolemUpgrade.add(result, upgrade);
        return result;
    }
}

