/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.recipe;

import dev.xkmc.l2core.serial.recipe.AbstractSmithingRecipe;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.item.data.GolemUpgrade;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.item.upgrade.AddSlotTemplate;
import dev.xkmc.modulargolems.init.registrate.GolemMiscs;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;

public class GolemSmithAddSlotRecipe
extends AbstractSmithingRecipe<GolemSmithAddSlotRecipe> {
    public final Ingredient template;
    public final Ingredient base;
    public final Ingredient addition;

    public GolemSmithAddSlotRecipe(Ingredient template, Ingredient base, Ingredient addition, ItemStack result) {
        super(template, base, addition, result);
        this.template = template;
        this.base = base;
        this.addition = addition;
    }

    public boolean matches(SmithingRecipeInput input, Level level) {
        if (!this.template.test(input.template())) {
            return false;
        }
        if (!this.base.test(input.base())) {
            return false;
        }
        Ingredient ing = GolemHolder.getCraftingMaterial(input.base());
        if (ing == null || !ing.test(input.addition())) {
            return false;
        }
        GolemUpgrade upgrade = GolemHolder.getUpgrades(input.base());
        return !upgrade.contains(input.template().getItem());
    }

    public boolean isAdditionIngredient(ItemStack stack) {
        return GolemMaterial.getMaterial(stack).isPresent();
    }

    public ItemStack assemble(SmithingRecipeInput input, HolderLookup.Provider pvd) {
        ItemStack stack = input.base().copy();
        GolemUpgrade.add(stack, (AddSlotTemplate)input.template().getItem());
        return stack;
    }

    public AbstractSmithingRecipe.Serializer<GolemSmithAddSlotRecipe> getSerializer() {
        return (AbstractSmithingRecipe.Serializer)GolemMiscs.SMITH_ADD_SLOT.get();
    }
}

