/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.recipe;

import dev.xkmc.l2core.serial.recipe.AbstractShapedRecipe;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.item.data.GolemHolderMaterial;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import dev.xkmc.modulargolems.init.registrate.GolemMiscs;
import java.util.ArrayList;
import javax.annotation.ParametersAreNullableByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;

public class GolemReplaceRecipe
extends AbstractShapedRecipe<GolemReplaceRecipe> {
    public GolemReplaceRecipe(String group, ShapedRecipePattern pattern, ItemStack result) {
        super(group, pattern, result);
    }

    public boolean matches(CraftingInput cont, Level level) {
        if (!super.matches(cont, level)) {
            return false;
        }
        for (int i = 0; i < cont.size(); ++i) {
            ItemStack input = cont.getItem(i);
            if (input.isEmpty() || !(input.getItem() instanceof GolemPart) || !GolemPart.getMaterial(input).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(CraftingInput cont, HolderLookup.Provider access) {
        boolean holderFirst = false;
        ItemStack holder = null;
        ResourceLocation mat = null;
        IGolemPart[] parts = null;
        IGolemPart<?> sel = null;
        for (int i = 0; i < cont.size(); ++i) {
            ItemStack input = cont.getItem(i);
            if (input.isEmpty()) continue;
            Item item = input.getItem();
            if (item instanceof GolemHolder) {
                GolemHolder h = (GolemHolder)item;
                holder = input;
                parts = h.getEntityType().values();
                if (sel == null) {
                    holderFirst = true;
                }
            }
            if (!((item = input.getItem()) instanceof GolemPart)) continue;
            GolemPart p = (GolemPart)item;
            mat = GolemPart.getMaterial(input).orElse(null);
            sel = (IGolemPart<?>)p.getPart();
        }
        return this.replacePart(holder, mat, parts, sel, holderFirst);
    }

    public ItemStack assembleForJEI(ResourceLocation mat) {
        boolean holderFirst = false;
        ItemStack holder = null;
        IGolemPart[] parts = null;
        IGolemPart<?> sel = null;
        for (Ingredient ing : this.getIngredients()) {
            ItemStack input;
            if (ing.isEmpty() || ing.getItems().length != 1 || (input = ing.getItems()[0]).isEmpty()) continue;
            Item item = input.getItem();
            if (item instanceof GolemHolder) {
                GolemHolder h = (GolemHolder)item;
                holder = input;
                parts = h.getEntityType().values();
                if (sel == null) {
                    holderFirst = true;
                }
            }
            if (!((item = input.getItem()) instanceof GolemPart)) continue;
            GolemPart p = (GolemPart)item;
            sel = (IGolemPart<?>)p.getPart();
        }
        return this.replacePart(holder, mat, parts, sel, holderFirst);
    }

    @ParametersAreNullableByDefault
    public ItemStack replacePart(ItemStack holder, ResourceLocation mat, IGolemPart<?>[] parts, IGolemPart<?> sel, boolean holderFirst) {
        ArrayList<GolemHolderMaterial.Entry> list;
        if (holder == null || parts == null || mat == null || sel == null) {
            return ItemStack.EMPTY;
        }
        int index = -1;
        if (!holderFirst) {
            for (i = 0; i < parts.length; ++i) {
                if (parts[i].toItem() != sel.toItem()) continue;
                index = i;
                break;
            }
        } else {
            for (i = parts.length - 1; i >= 0; --i) {
                if (parts[i].toItem() != sel.toItem()) continue;
                index = i;
                break;
            }
        }
        if (index < 0) {
            return ItemStack.EMPTY;
        }
        ItemStack result = holder.copy();
        GolemHolderMaterial matData = (GolemHolderMaterial)GolemItems.HOLDER_MAT.get(result);
        if (matData == null || matData.size() < parts.length) {
            result = holder.getItem().getDefaultInstance();
            list = new ArrayList();
            for (IGolemPart<?> e : parts) {
                list.add(new GolemHolderMaterial.Entry(e.toItem(), ModularGolems.loc("empty")));
            }
        } else {
            list = matData.copyParts();
        }
        list.set(index, new GolemHolderMaterial.Entry(sel.toItem(), mat));
        return GolemItems.HOLDER_MAT.set(result, (Object)new GolemHolderMaterial(list));
    }

    public AbstractShapedRecipe.Serializer<GolemReplaceRecipe> getSerializer() {
        return (AbstractShapedRecipe.Serializer)GolemMiscs.REPLACE.get();
    }
}

