/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.recipe;

import dev.xkmc.l2core.serial.recipe.AbstractShapedRecipe;
import dev.xkmc.modulargolems.content.item.data.GolemHolderMaterial;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import dev.xkmc.modulargolems.init.registrate.GolemMiscs;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;

public class GolemAssembleRecipe
extends AbstractShapedRecipe<GolemAssembleRecipe> {
    public GolemAssembleRecipe(String group, ShapedRecipePattern pattern, ItemStack result) {
        super(group, pattern, result);
    }

    public boolean matches(CraftingInput cont, Level level) {
        if (!super.matches(cont, level)) {
            return false;
        }
        for (int i = 0; i < cont.size(); ++i) {
            Item item;
            ItemStack input = cont.getItem(i);
            if (input.isEmpty() || !((item = input.getItem()) instanceof GolemPart)) continue;
            GolemPart part = (GolemPart)item;
            if (!GolemPart.getMaterial(input).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(CraftingInput cont, HolderLookup.Provider access) {
        ItemStack stack = super.assemble(cont, access);
        ArrayList<GolemHolderMaterial.Entry> list = new ArrayList<GolemHolderMaterial.Entry>();
        for (int i = 0; i < cont.size(); ++i) {
            Item item;
            ItemStack input = cont.getItem(i);
            if (input.isEmpty() || !((item = input.getItem()) instanceof GolemPart)) continue;
            GolemPart part = (GolemPart)item;
            GolemPart.getMaterial(input).ifPresent(mat -> list.add(new GolemHolderMaterial.Entry(part, (ResourceLocation)mat)));
        }
        return GolemItems.HOLDER_MAT.set(stack, (Object)new GolemHolderMaterial(list));
    }

    public AbstractShapedRecipe.Serializer<GolemAssembleRecipe> getSerializer() {
        return (AbstractShapedRecipe.Serializer)GolemMiscs.ASSEMBLE.get();
    }
}

