/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.modifier.special;

import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SonicAttackGoal
extends Goal {
    private static final int WAIT = 200;
    private static final int DELAY = 34;
    private final AbstractGolemEntity<?, ?> warden;
    private final int lv;
    private int attackTime = 200;
    private Vec3 targetPos;

    public SonicAttackGoal(AbstractGolemEntity<?, ?> warden, int lv) {
        this.warden = warden;
        this.lv = lv;
    }

    public boolean canUse() {
        LivingEntity livingentity = this.warden.getTarget();
        if (this.targetPos != null && this.attackTime <= 34) {
            return true;
        }
        return livingentity != null && livingentity.isAlive() && this.warden.canAttack(livingentity) && this.warden.distanceToSqr((Entity)livingentity) < 256.0 && (this.warden.getNavigation().isStuck() || this.warden.distanceToSqr((Entity)livingentity) > 4.0);
    }

    public void start() {
        this.attackTime = 200;
        this.targetPos = null;
    }

    public void stop() {
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        --this.attackTime;
        LivingEntity le = this.warden.getTarget();
        if (le != null) {
            if (this.attackTime == 34) {
                this.warden.playSound(SoundEvents.WARDEN_SONIC_CHARGE, 3.0f, 1.0f);
            }
            if (this.attackTime <= 34) {
                this.targetPos = le.getEyePosition();
            }
        }
        if (this.attackTime <= 0 && this.targetPos != null) {
            Vec3 src = this.warden.position().add(0.0, (double)1.6f, 0.0);
            Vec3 dst = this.targetPos.subtract(src);
            Vec3 dir = dst.normalize();
            for (int i = 1; i < 17; ++i) {
                Vec3 vec33 = src.add(dir.scale((double)i));
                Level level = this.warden.level();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel level2 = (ServerLevel)level;
                level2.sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, vec33.x, vec33.y, vec33.z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            this.warden.playSound(SoundEvents.WARDEN_SONIC_BOOM, 3.0f, 1.0f);
            AttributeInstance attr = this.warden.getAttribute(GolemTypes.GOLEM_SWEEP.holder());
            ArrayList<LivingEntity> target = new ArrayList<LivingEntity>();
            if (attr != null && attr.getValue() > 0.0) {
                AABB aabb = new AABB(src, src.add(dir.scale(16.0)));
                for (Entity e : this.warden.level().getEntities(this.warden, aabb)) {
                    LivingEntity x;
                    if (!(e instanceof LivingEntity) || !this.warden.canAttack(x = (LivingEntity)e)) continue;
                    target.add(x);
                }
            }
            if (le != null && !target.contains(le)) {
                target.add(le);
            }
            for (LivingEntity e : target) {
                e.hurt(this.warden.level().damageSources().sonicBoom(this.warden), (float)(10 * this.lv));
                double d1 = 0.5 * (1.0 - e.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                double d0 = 2.5 * (1.0 - e.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                e.push(dir.x() * d0, dir.y() * d1, dir.z() * d0);
            }
            this.attackTime = 200;
            this.targetPos = null;
        }
        super.tick();
    }
}

