/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.modifier.special;

import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.content.entity.mode.GolemModes;
import dev.xkmc.modulargolems.events.event.GolemHandleExpEvent;
import dev.xkmc.modulargolems.events.event.GolemHandleItemEvent;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.data.MGLangData;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.mixin.ExperienceOrbAccessor;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class PickupGoal
extends Goal {
    private static final int INTERVAL = 10;
    private static final int DELAY = 80;
    private static final String KEY = "modulargolems:pickup_delay";
    private final AbstractGolemEntity<?, ?> golem;
    private final int lv;
    private int delay = 0;
    private int destroyItemCount = 0;
    private int destroyExpCount = 0;
    private BlockEntity target;

    public PickupGoal(AbstractGolemEntity<?, ?> golem, int lv) {
        this.golem = golem;
        this.lv = lv;
    }

    public boolean canUse() {
        return true;
    }

    public void tick() {
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        this.delay = 10;
        AABB box = this.golem.getBoundingBox().inflate((double)(this.lv * (Integer)MGConfig.COMMON.basePickupRange.get()));
        this.tryHandleItem(box);
        this.tryHandleExp(box);
    }

    private void tryHandleItem(AABB box) {
        Player player = this.golem.getOwner();
        List items = this.golem.level().getEntities(EntityTypeTest.forClass(ItemEntity.class), box, e -> true);
        this.validateTarget();
        GolemConfigEntry config = this.golem.getConfigEntry(null);
        for (ItemEntity item : items) {
            if (config != null && !config.pickupFilter.allowPickup(item.getItem())) continue;
            this.handleLeftoverItem(item, player);
        }
        if (this.destroyItemCount > 0 && player != null) {
            ModularGolems.LOGGER.info(MGLangData.DESTROY_ITEM.get(new Object[]{this.golem, this.destroyItemCount}).getString());
            player.sendSystemMessage((Component)MGLangData.DESTROY_ITEM.get(new Object[]{this.golem, this.destroyItemCount}));
            this.destroyItemCount = 0;
        }
    }

    private void tryHandleExp(AABB box) {
        Player player = this.golem.getOwner();
        List exps = this.golem.level().getEntities(EntityTypeTest.forClass(ExperienceOrb.class), box, e -> true);
        ExperienceOrb first = null;
        for (ExperienceOrb exp : exps) {
            exp.value *= ((ExperienceOrbAccessor)exp).getCount();
            ((ExperienceOrbAccessor)exp).setCount(1);
            if (first == null) {
                first = exp;
                continue;
            }
            first.value += exp.value;
            exp.discard();
        }
        if (first != null) {
            this.handleLeftoverExp(first, player);
        }
        if (this.destroyExpCount > 0 && player != null) {
            player.sendSystemMessage((Component)MGLangData.DESTROY_EXP.get(new Object[]{this.golem, this.destroyExpCount}));
            this.destroyExpCount = 0;
        }
    }

    private int repairGolemAndItems(int exp) {
        Optional entry = EnchantmentHelper.getRandomItemWith((DataComponentType)EnchantmentEffectComponents.REPAIR_WITH_XP, this.golem, ItemStack::isDamaged);
        if (entry.isPresent()) {
            ItemStack itemstack = ((EnchantedItemInUse)entry.get()).itemStack();
            float ratio = itemstack.getXpRepairRatio();
            int recovered = Math.min((int)((float)exp * ratio), itemstack.getDamageValue());
            itemstack.setDamageValue(itemstack.getDamageValue() - recovered);
            int remain = ratio <= 0.0f ? 0 : (int)Math.max(0.0f, (float)exp - (float)recovered / ratio);
            return remain > 0 ? this.repairGolemAndItems(remain) : 0;
        }
        if (!this.golem.hasFlag(GolemFlags.MENDING)) {
            return exp;
        }
        float lost = this.golem.getMaxHealth() - this.golem.getHealth();
        float ratio = ((Integer)MGConfig.COMMON.mendingXpCost.get()).intValue();
        float heal = Math.min(lost, (float)exp / ratio);
        int cost = (int)(heal * ratio);
        this.golem.heal(heal);
        return exp - cost;
    }

    private void handleLeftoverItem(ItemEntity item, @Nullable Player player) {
        IItemHandler handler;
        if (item.getPersistentData().contains(KEY, 4) && item.getPersistentData().getLong(KEY) > item.level().getGameTime()) {
            return;
        }
        GolemHandleItemEvent event = new GolemHandleItemEvent(this.golem, item);
        NeoForge.EVENT_BUS.post((Event)event);
        if (item.getItem().isEmpty()) {
            item.discard();
        }
        if (item.isRemoved()) {
            return;
        }
        if (this.target != null && this.target.getLevel() != null && this.golem.getMode() == GolemModes.STAND && (handler = (IItemHandler)this.target.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, this.target.getBlockPos(), null)) != null) {
            ItemStack remain = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)item.getItem(), (boolean)false);
            if (remain.isEmpty()) {
                item.discard();
                return;
            }
            item.setItem(remain);
        }
        if (player != null && player.isAlive()) {
            item.playerTouch(player);
            if (!item.isRemoved()) {
                item.moveTo(player.position());
                item.getPersistentData().putLong(KEY, item.level().getGameTime() + 80L);
                return;
            }
        }
        if (item.isRemoved()) {
            return;
        }
        if (this.golem.hasFlag(GolemFlags.NO_DESTROY) || item.hasPickUpDelay()) {
            return;
        }
        this.destroyItemCount += item.getItem().getCount();
        item.discard();
    }

    private void handleLeftoverExp(ExperienceOrb exp, @Nullable Player player) {
        exp.value = this.repairGolemAndItems(exp.value);
        GolemHandleExpEvent event = new GolemHandleExpEvent(this.golem, exp);
        NeoForge.EVENT_BUS.post((Event)event);
        if (exp.value <= 0) {
            exp.discard();
        }
        if (exp.isRemoved()) {
            return;
        }
        if (player != null) {
            player.takeXpDelay = 0;
            exp.playerTouch(player);
        }
        if (exp.isRemoved()) {
            return;
        }
        this.destroyExpCount += exp.value;
        exp.discard();
    }

    private void validateTarget() {
        if (this.target != null && !this.target.isRemoved() && this.target.getLevel() == this.golem.level() && this.target.getBlockPos().distSqr((Vec3i)this.golem.blockPosition()) <= 9.0) {
            return;
        }
        this.target = null;
        BlockPos origin = this.golem.blockPosition();
        BlockPos.MutableBlockPos pos = origin.mutable();
        int r = 1;
        double dist = Double.POSITIVE_INFINITY;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    double d;
                    pos.setWithOffset((Vec3i)origin, i, j, k);
                    if (!this.golem.level().getBlockState((BlockPos)pos).is(MGTagGen.POTENTIAL_DST)) continue;
                    BlockEntity be = this.golem.level().getBlockEntity((BlockPos)pos);
                    IItemHandler handler = (IItemHandler)this.golem.level().getCapability(Capabilities.ItemHandler.BLOCK, (BlockPos)pos, null);
                    if (be == null || handler == null || !((d = pos.distToCenterSqr((Position)this.golem.position())) < dist)) continue;
                    this.target = be;
                    dist = d;
                }
            }
        }
    }
}

