/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.modifier.special;

import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.targeting.TargetManager;
import dev.xkmc.modulargolems.content.modifier.special.BaseRangedAttackGoal;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.entity.EntityTypeTest;

public abstract class MultiTargetRangedGoal
extends BaseRangedAttackGoal {
    protected final int lv;
    @Nullable
    private LinkedList<LivingEntity> targets = null;
    private int cd = 0;

    public MultiTargetRangedGoal(int waitTime, int near, int far, AbstractGolemEntity<?, ?> golem, int lv) {
        super(waitTime, near, far, golem, lv);
        this.lv = lv;
    }

    protected void makeTarget() {
        List list = this.golem.level().getEntities(EntityTypeTest.forClass(LivingEntity.class), this.golem.getBoundingBox().inflate((double)this.searchRange()), e -> this.golem.canAttack((LivingEntity)e) && this.golem.hasLineOfSight((Entity)e));
        list.sort(Comparator.comparing(ke -> Optional.ofNullable(TargetManager.predicateTarget(this.golem, ke)).map(Enum::ordinal).orElse(100)));
        this.targets = new LinkedList();
        for (LivingEntity e2 : list) {
            if (this.targets.size() >= this.getMaxTarget()) break;
            this.targets.add(e2);
        }
    }

    protected abstract int searchRange();

    protected abstract int getMaxTarget();

    protected abstract int cd();

    @Override
    protected final boolean performAttack(LivingEntity target) {
        if (this.targets == null) {
            this.makeTarget();
        }
        if (this.cd > 0) {
            --this.cd;
            return false;
        }
        if (this.targets.isEmpty()) {
            this.targets = null;
            return true;
        }
        LivingEntity e = this.targets.poll();
        if (e.isAlive()) {
            this.performAttackImpl(e);
            this.cd = this.cd();
        }
        if (this.targets.isEmpty()) {
            this.targets = null;
            return true;
        }
        return false;
    }

    protected abstract void performAttackImpl(LivingEntity var1);
}

