/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.modifier.special;

import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;

public class EarthquakeHelper {
    public static final byte FLAG = 83;
    public static final double RANGE = 5.0;

    public static void performEarthQuake(AbstractGolemEntity<?, ?> golem) {
        for (Map.Entry<GolemModifier, Integer> e : golem.getModifiers().entrySet()) {
            GolemModifier golemModifier = e.getKey();
            if (!(golemModifier instanceof Modifier)) continue;
            Modifier m = (Modifier)((Object)golemModifier);
            m.performEarthQuake(golem, e.getValue());
            break;
        }
        golem.level().broadcastEntityEvent(golem, (byte)83);
    }

    public static void makeParticles(LivingEntity le, float vec, float math) {
        if (le.level().isClientSide) {
            for (int i1 = 0; i1 < 80 + le.getRandom().nextInt(12); ++i1) {
                double DeltaMovementX = le.getRandom().nextGaussian() * 0.07;
                double DeltaMovementY = le.getRandom().nextGaussian() * 0.07;
                double DeltaMovementZ = le.getRandom().nextGaussian() * 0.07;
                float f = Mth.cos((float)(le.yBodyRot * ((float)Math.PI / 180)));
                float f1 = Mth.sin((float)(le.yBodyRot * ((float)Math.PI / 180)));
                float angle = (float)Math.PI / 180 * le.yBodyRot + (float)i1;
                double extraX = 2.0f * Mth.sin((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = 2.0f * Mth.cos((float)angle);
                double theta = (double)le.yBodyRot * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.0);
                double vecZ = Math.sin(theta);
                int hitX = Mth.floor((double)(le.getX() + (double)vec * vecX + extraX));
                int hitY = Mth.floor((double)le.getY());
                int hitZ = Mth.floor((double)(le.getZ() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = le.level().getBlockState(hit.below());
                le.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, block), le.getX() + (double)vec * vecX + extraX + (double)(f * math), le.getY() + extraY, le.getZ() + (double)vec * vecZ + extraZ + (double)(f1 * math), DeltaMovementX, DeltaMovementY, DeltaMovementZ);
            }
        }
    }

    public static void launch(LivingEntity le, Entity e, float f) {
        double d0 = e.getX() - le.getX();
        double d1 = e.getZ() - le.getZ();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        e.push(d0 / d2 * (double)f, 0.375 * (double)f, d1 / d2 * (double)f);
    }

    public static double getExtraRange(AbstractGolemEntity<?, ?> golem, LivingEntity target) {
        for (Map.Entry<GolemModifier, Integer> e : golem.getModifiers().entrySet()) {
            GolemModifier golemModifier = e.getKey();
            if (!(golemModifier instanceof Modifier)) continue;
            Modifier m = (Modifier)((Object)golemModifier);
            return m.getEarthquakeRange(golem, target, e.getValue());
        }
        return 25.0;
    }

    public static interface Modifier {
        public void performEarthQuake(AbstractGolemEntity<?, ?> var1, int var2);

        default public double getEarthquakeRange(AbstractGolemEntity<?, ?> golem, LivingEntity target, int lv) {
            return 25.0;
        }
    }
}

