/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.modifier.special;

import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class BaseRangedAttackGoal
extends Goal {
    private final int waitTime;
    private final int near;
    private final int far;
    protected final AbstractGolemEntity<?, ?> golem;
    protected final int lv;
    public long attackTime;
    private boolean lock;

    public BaseRangedAttackGoal(int waitTime, int near, int far, AbstractGolemEntity<?, ?> golem, int lv) {
        this.golem = golem;
        this.lv = lv;
        this.waitTime = waitTime;
        this.attackTime = 0L;
        this.near = near * near;
        this.far = far * far;
    }

    public boolean canUse() {
        LivingEntity livingentity = this.golem.getTarget();
        return livingentity != null && livingentity.isAlive() && this.golem.canAttack(livingentity) && this.golem.distanceToSqr((Entity)livingentity) < (double)this.far && (this.golem.getNavigation().isStuck() || this.golem.distanceToSqr((Entity)livingentity) > (double)this.near);
    }

    public void start() {
        if (this.attackTime == 0L) {
            this.attackTime = this.golem.level().getGameTime() + (long)this.waitTime;
        }
    }

    public void stop() {
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        boolean mayAttack;
        LivingEntity le = this.golem.getTarget();
        long time = this.golem.level().getGameTime();
        boolean bl = mayAttack = this.golem.specialAttackCoolDown <= 0 || this.lock;
        if (this.attackTime <= time && le != null && le.isAlive() && mayAttack) {
            if (this.performAttack(le)) {
                this.attackTime = time + (long)this.waitTime;
                this.lock = false;
            } else {
                this.lock = true;
            }
            this.golem.specialAttackCoolDown = 20;
        }
        super.tick();
    }

    public void setInitialDelay(int delay) {
        this.attackTime = delay;
    }

    protected abstract boolean performAttack(LivingEntity var1);
}

