/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.modifier.immunes;

import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.data.MGConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;

public class DamageCapModifier
extends GolemModifier {
    public DamageCapModifier() {
        super(StatFilterType.HEALTH, 5);
    }

    @Override
    public void onDamaged(AbstractGolemEntity<?, ?> entity, DamageData.Defence event, int level) {
        if (event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return;
        }
        float factor = (float)Math.max(0.0, (2.0 - (double)level * 0.2) * (Double)MGConfig.COMMON.damageCap.get());
        float max = factor * entity.getMaxHealth();
        event.addDealtModifier(DamageModifier.nonlinearMiddle((int)175, e -> {
            if (e > max) {
                entity.level().broadcastEntityEvent((Entity)entity, (byte)29);
                return max;
            }
            return e;
        }, (ResourceLocation)this.getRegistryName()));
    }

    @Override
    public List<MutableComponent> getDetail(int level) {
        float factor = (float)Math.max(0.0, (2.0 - (double)level * 0.2) * (Double)MGConfig.COMMON.damageCap.get());
        int perc = Math.round(100.0f * factor);
        return List.of(Component.translatable((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{perc}).withStyle(ChatFormatting.GREEN));
    }
}

