/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.modifier.common;

import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.data.MGConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ThornModifier
extends GolemModifier {
    private static float getPercent() {
        return (float)((Double)MGConfig.COMMON.thorn.get()).doubleValue();
    }

    public ThornModifier() {
        super(StatFilterType.HEALTH, 5);
    }

    @Override
    public void postDamaged(AbstractGolemEntity<?, ?> entity, DamageData.DefenceMax event, int level) {
        LivingEntity living;
        if (level == 0) {
            return;
        }
        DamageSource source = event.getSource();
        if (!source.is(L2DamageTypes.DIRECT)) {
            return;
        }
        Entity entity2 = source.getDirectEntity();
        if (entity2 instanceof LivingEntity && (living = (LivingEntity)entity2).isAlive()) {
            living.hurt(entity.level().damageSources().thorns(entity), event.getDamageIncoming() * ThornModifier.getPercent() * (float)level);
        }
    }

    @Override
    public List<MutableComponent> getDetail(int v) {
        int reflect = Math.round(ThornModifier.getPercent() * (float)v * 100.0f);
        return List.of(Component.translatable((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{reflect}).withStyle(ChatFormatting.GREEN));
    }
}

