/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.modifier.common;

import dev.xkmc.l2core.base.effects.EffectUtil;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.phys.AABB;

public class BellModifier
extends GolemModifier {
    public BellModifier() {
        super(StatFilterType.HEALTH, 1);
    }

    @Override
    public void onSetTarget(AbstractGolemEntity<?, ?> golem, Mob mob, int level) {
        AABB aabb = golem.getBoundingBox().inflate(48.0);
        List list = golem.level().getEntitiesOfClass(Mob.class, aabb, golem::canAttack);
        boolean sound = false;
        for (Mob e : list) {
            if (!(e instanceof Enemy) || e instanceof Creeper || !e.canAttack(golem)) continue;
            sound |= !e.hasEffect(MobEffects.GLOWING);
            EffectUtil.addEffect((LivingEntity)e, (MobEffectInstance)new MobEffectInstance(MobEffects.GLOWING, 200), golem);
            if (e.getTarget() instanceof AbstractGolemEntity) continue;
            e.setTarget(golem);
        }
        if (sound) {
            golem.playSound(SoundEvents.BELL_BLOCK, 1.0f, 1.0f);
        }
    }
}

