/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.modifier.base;

import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.data.MGConfig;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class TargetBonusModifier
extends GolemModifier {
    private final Predicate<LivingEntity> pred;

    public TargetBonusModifier(Predicate<LivingEntity> pred) {
        super(StatFilterType.ATTACK, 2);
        this.pred = pred;
    }

    @Override
    public void onHurtTarget(AbstractGolemEntity<?, ?> entity, DamageData.Offence event, int level) {
        if (this.pred.test(event.getTarget())) {
            float factor = (float)(1.0 + (double)level * (Double)MGConfig.COMMON.targetDamageBonus.get());
            event.addHurtModifier(DamageModifier.multTotal((float)factor, (ResourceLocation)this.getRegistryName()));
        }
    }

    @Override
    public List<MutableComponent> getDetail(int v) {
        int perc = (int)((Double)MGConfig.COMMON.targetDamageBonus.get() * 100.0 * (double)v);
        return List.of(Component.translatable((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{perc}).withStyle(ChatFormatting.GREEN));
    }
}

