/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.modifier.base;

import dev.xkmc.l2core.base.effects.EffectUtil;
import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.data.MGLangData;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PotionAttackModifier
extends GolemModifier {
    private final Function<Integer, MobEffectInstance> func;

    public PotionAttackModifier(StatFilterType type, int maxLevel, Function<Integer, MobEffectInstance> func) {
        super(type, maxLevel);
        this.func = func;
    }

    @Override
    public void postHurtTarget(AbstractGolemEntity<?, ?> entity, DamageData.DefenceMax event, int level) {
        this.applyPotion(entity, event.getTarget(), level);
    }

    @Override
    public void postDamaged(AbstractGolemEntity<?, ?> entity, DamageData.DefenceMax event, int level) {
        Entity entity2 = event.getSource().getDirectEntity();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            this.applyPotion(entity, attacker, level);
        }
    }

    private void applyPotion(AbstractGolemEntity<?, ?> self, LivingEntity target, int level) {
        if (!target.level().isClientSide()) {
            EffectUtil.addEffect((LivingEntity)target, (MobEffectInstance)this.func.apply(level), self);
        }
    }

    @Override
    public List<MutableComponent> getDetail(int v) {
        MobEffectInstance ins = this.func.apply(v);
        MutableComponent lang = Component.translatable((String)ins.getDescriptionId());
        Holder mobeffect = ins.getEffect();
        if (ins.getAmplifier() > 0) {
            lang = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{lang, Component.translatable((String)("potion.potency." + ins.getAmplifier()))});
        }
        if (ins.getDuration() >= 20) {
            lang = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{lang, MobEffectUtil.formatDuration((MobEffectInstance)ins, (float)1.0f, (float)20.0f)});
        }
        lang = lang.withStyle(((MobEffect)mobeffect.value()).getCategory().getTooltipFormatting());
        return List.of(MGLangData.POTION_ATTACK.get(lang).withStyle(ChatFormatting.GREEN));
    }
}

