/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.modifier.base;

import dev.xkmc.l2core.init.reg.registrate.NamedEntry;
import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.modulargolems.content.config.GolemPartConfig;
import dev.xkmc.modulargolems.content.core.GolemType;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.content.item.upgrade.IUpgradeItem;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class GolemModifier
extends NamedEntry<GolemModifier> {
    public static final int MAX_LEVEL = 5;
    public final StatFilterType type;
    public final int maxLevel;

    public GolemModifier(StatFilterType type, int maxLevel) {
        super(GolemTypes.MODIFIERS);
        this.type = type;
        this.maxLevel = maxLevel;
    }

    public Component getTooltip(int v) {
        MutableComponent ans = this.getDesc();
        if (this.maxLevel > 1) {
            ans = ans.append(" ").append((Component)Component.translatable((String)("potion.potency." + (v - 1))));
        }
        return ans.withStyle(ChatFormatting.LIGHT_PURPLE);
    }

    public List<MutableComponent> getDetail(int v) {
        return List.of(Component.translatable((String)(this.getDescriptionId() + ".desc")).withStyle(ChatFormatting.GREEN));
    }

    public void onGolemSpawn(AbstractGolemEntity<?, ?> entity, int level) {
    }

    public boolean onAttacked(AbstractGolemEntity<?, ?> entity, DamageData.Attack event, int level) {
        return false;
    }

    public void onDamaged(AbstractGolemEntity<?, ?> entity, DamageData.Defence event, int level) {
    }

    public void postDamaged(AbstractGolemEntity<?, ?> entity, DamageData.DefenceMax event, int level) {
    }

    public void onAttackTarget(AbstractGolemEntity<?, ?> entity, DamageData.Attack event, int level) {
    }

    public void onHurtTarget(AbstractGolemEntity<?, ?> entity, DamageData.Offence cache, int level) {
    }

    public void postHurtTarget(AbstractGolemEntity<?, ?> entity, DamageData.DefenceMax event, int level) {
    }

    public double onHealTick(double heal, AbstractGolemEntity<?, ?> entity, int level) {
        return this.onInventoryHealTick(heal, new HealingContext(entity.getHealth(), entity.getMaxHealth(), (Entity)entity), level);
    }

    public double onInventoryHealTick(double heal, HealingContext ctx, int level) {
        return heal;
    }

    public int addSlot(List<IUpgradeItem> upgrades, int lv) {
        return 0;
    }

    public void onAiStep(AbstractGolemEntity<?, ?> golem, int level) {
    }

    public void onRegisterFlag(Consumer<GolemFlags> addFlag) {
    }

    public void onRegisterGoals(AbstractGolemEntity<?, ?> entity, int lv, BiConsumer<Integer, Goal> addGoal) {
    }

    public void onClientTick(AbstractGolemEntity<?, ?> entity, int level) {
    }

    public boolean canExistOn(GolemPart<?, ?> part) {
        return GolemPartConfig.get().getFilter(part).getOrDefault((Object)this.type, 0.0) > 0.0;
    }

    public void onSetTarget(AbstractGolemEntity<?, ?> golem, Mob mob, int level) {
    }

    public boolean fitsOn(GolemType<?, ?> type) {
        return true;
    }

    public void modifySource(AbstractGolemEntity<?, ?> golem, CreateSourceEvent event, int value) {
    }

    public void handleEvent(AbstractGolemEntity<?, ?> golem, int value, byte event) {
    }

    public InteractionResult interact(Player player, AbstractGolemEntity<?, ?> golem, InteractionHand hand, int value) {
        return InteractionResult.PASS;
    }

    public record HealingContext(float health, float maxHealth, Entity owner) {
    }
}

