/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.menu.registry;

import dev.xkmc.l2serial.network.SerialPacketBase;
import dev.xkmc.l2tabs.compat.common.CuriosEventHandler;
import dev.xkmc.modulargolems.compat.curio.CurioCompatRegistry;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.menu.equipment.EquipmentsMenuPvd;
import dev.xkmc.modulargolems.content.menu.registry.IMenuPvd;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public record OpenEquipmentMenuToServer(UUID uuid, Type type) implements SerialPacketBase<OpenEquipmentMenuToServer>
{
    public void handle(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        Entity entry = sp.serverLevel().getEntity(this.uuid);
        if (!(entry instanceof AbstractGolemEntity)) {
            return;
        }
        AbstractGolemEntity golem = (AbstractGolemEntity)entry;
        if (!golem.canModify(player)) {
            return;
        }
        IMenuPvd pvd = this.type.construct(golem);
        if (pvd != null) {
            CuriosEventHandler.openMenuWrapped((ServerPlayer)sp, () -> player.openMenu((MenuProvider)pvd, pvd::writeBuffer));
        }
    }

    public static enum Type {
        EQUIPMENT(EquipmentsMenuPvd::new),
        CURIOS(CurioCompatRegistry::create);

        private final Function<AbstractGolemEntity<?, ?>, IMenuPvd> func;

        private Type(Function<AbstractGolemEntity<?, ?>, IMenuPvd> func) {
            this.func = func;
        }

        @Nullable
        public IMenuPvd construct(AbstractGolemEntity<?, ?> entry) {
            return this.func.apply(entry);
        }
    }
}

