/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.menu.registry;

import dev.xkmc.l2serial.network.SerialPacketBase;
import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.capability.GolemConfigStorage;
import dev.xkmc.modulargolems.content.menu.config.ConfigMenuProvider;
import dev.xkmc.modulargolems.content.menu.filter.ItemConfigMenuProvider;
import dev.xkmc.modulargolems.content.menu.path.PathConfigMenuProvider;
import dev.xkmc.modulargolems.content.menu.registry.IMenuPvd;
import dev.xkmc.modulargolems.content.menu.target.TargetConfigMenuProvider;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;

public record OpenConfigMenuToServer(UUID uuid, int color, Type type) implements SerialPacketBase<OpenConfigMenuToServer>
{
    public void handle(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        GolemConfigEntry entry = GolemConfigStorage.get(player.level()).getStorage(this.uuid, this.color);
        if (entry == null) {
            return;
        }
        if (!player.getUUID().equals(this.uuid)) {
            return;
        }
        IMenuPvd pvd = this.type.construct(sp.serverLevel(), entry);
        sp.openMenu((MenuProvider)pvd, pvd::writeBuffer);
    }

    public static enum Type {
        TOGGLE(ConfigMenuProvider::fromPacket),
        ITEM(ItemConfigMenuProvider::fromPacket),
        TARGET(TargetConfigMenuProvider::fromPacket),
        PATH(PathConfigMenuProvider::fromPacket);

        private final BiFunction<ServerLevel, GolemConfigEntry, IMenuPvd> func;

        private Type(BiFunction<ServerLevel, GolemConfigEntry, IMenuPvd> func) {
            this.func = func;
        }

        public IMenuPvd construct(ServerLevel level, GolemConfigEntry entry) {
            return this.func.apply(level, entry);
        }
    }
}

