/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.menu.ghost;

import dev.xkmc.l2core.base.menu.base.MenuLayoutConfig;
import dev.xkmc.l2core.base.menu.base.PredSlot;
import dev.xkmc.l2core.base.menu.base.SpriteManager;
import dev.xkmc.modulargolems.content.menu.ghost.IGhostContainer;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class GhostItemMenu
extends AbstractContainerMenu {
    protected final Inventory inventory;
    public final SpriteManager manager;
    public final MenuLayoutConfig sprite;
    protected final Container container;
    private int added = 0;

    protected GhostItemMenu(MenuType<?> type, int wid, Inventory plInv, SpriteManager manager, Container container) {
        super(type, wid);
        this.inventory = plInv;
        this.manager = manager;
        this.sprite = manager.get(plInv.player.level().registryAccess());
        this.container = container;
        int x = this.sprite.getPlInvX();
        int y = this.sprite.getPlInvY();
        this.bindPlayerInventory(plInv, x, y);
    }

    protected void bindPlayerInventory(Inventory plInv, int x, int y) {
        int k;
        for (k = 0; k < 3; ++k) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)plInv, j + k * 9 + 9, x + j * 18, y + k * 18));
            }
        }
        for (k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)plInv, k, x + k * 18, y + 58));
        }
    }

    protected void addSlot(String name, Predicate<ItemStack> pred) {
        this.sprite.getSlot(name, (x, y) -> new PredSlot(this.container, this.added++, x, y, pred), (n, i, j, s) -> this.addSlot(s));
    }

    protected abstract IGhostContainer getContainer(int var1);

    protected ItemStack getSlotContent(int slot) {
        return this.getContainer(slot).getItem(slot);
    }

    public void setSlotContent(int slot, ItemStack stack) {
        if (stack.isEmpty()) {
            this.removeContent(slot);
        } else if (this.getContainer(slot).getItem(slot).isEmpty()) {
            this.tryAddContent(slot, stack);
        } else {
            stack = stack.copy();
            stack.setCount(1);
            if (this.getContainer(slot).internalMatch(stack)) {
                return;
            }
            this.getContainer(slot).set(slot, stack);
        }
    }

    protected void tryAddContent(int slot, ItemStack stack) {
        IGhostContainer cont = this.getContainer(slot);
        if (cont.listSize() < cont.getContainerSize()) {
            stack = stack.copy();
            stack.setCount(1);
            if (cont.internalMatch(stack)) {
                return;
            }
            cont.set(-1, stack);
        }
    }

    protected void removeContent(int slot) {
        if (slot < 0 || this.getContainer(slot).getItem(slot).isEmpty()) {
            return;
        }
        this.getContainer(slot).set(slot, ItemStack.EMPTY);
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId < 36) {
            super.clicked(slotId, dragType, clickTypeIn, player);
        } else if (clickTypeIn != ClickType.THROW) {
            ItemStack held = this.getCarried();
            int slot = slotId - 36;
            if (clickTypeIn == ClickType.CLONE) {
                if (player.isCreative() && held.isEmpty()) {
                    ItemStack insert = this.getSlotContent(slot).copy();
                    insert.setCount(insert.getMaxStackSize());
                    this.setCarried(insert);
                }
            } else {
                ItemStack insert;
                if (held.isEmpty()) {
                    insert = ItemStack.EMPTY;
                } else {
                    insert = held.copy();
                    insert.setCount(1);
                }
                this.setSlotContent(slot, insert);
            }
        }
    }

    public boolean stillValid(Player player) {
        return player.isAlive();
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        if (index < 36) {
            ItemStack stackToInsert = this.getSlot(index).getItem();
            this.tryAddContent(0, stackToInsert);
        } else {
            this.removeContent(index - 36);
        }
        return ItemStack.EMPTY;
    }
}

