/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.menu.equipment;

import dev.xkmc.l2core.base.menu.base.BaseContainerMenu;
import dev.xkmc.l2core.base.menu.base.PredSlot;
import dev.xkmc.l2core.base.menu.base.SpriteManager;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.menu.equipment.EquipmentsContainer;
import dev.xkmc.modulargolems.events.event.GolemEquipEvent;
import dev.xkmc.modulargolems.events.event.GolemEquipItemEvent;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class EquipmentsMenu
extends BaseContainerMenu<EquipmentsMenu> {
    public static EquipmentSlot[] LARGE_SLOTS = new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static EquipmentSlot[] DOG_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.BODY};
    public static final SpriteManager MANAGER = new SpriteManager("modulargolems", "equipments");
    public final AbstractGolemEntity<?, ?> golem;
    protected final EquipmentSlot[] equipmentSlots;

    public static EquipmentsMenu fromNetwork(MenuType<EquipmentsMenu> type, int wid, Inventory plInv, RegistryFriendlyByteBuf buf) {
        AbstractGolemEntity golem;
        Entity entity = plInv.player.level().getEntity(buf.readInt());
        return new EquipmentsMenu(type, wid, plInv, entity instanceof AbstractGolemEntity ? (golem = (AbstractGolemEntity)entity) : null);
    }

    protected EquipmentsMenu(MenuType<?> type, int wid, Inventory plInv, @Nullable AbstractGolemEntity<?, ?> golem) {
        super(type, wid, plInv, MANAGER, EquipmentsContainer::new, false);
        this.golem = golem;
        EquipmentSlot[] equipmentSlotArray = this.equipmentSlots = golem instanceof DogGolemEntity ? DOG_SLOTS : LARGE_SLOTS;
        if (golem instanceof DogGolemEntity) {
            this.addSlot("head", e -> this.isValid(EquipmentSlot.HEAD, (ItemStack)e));
            this.addSlot("chest", e -> this.isValid(EquipmentSlot.BODY, (ItemStack)e));
        } else {
            this.addSlot("main", e -> this.isValid(EquipmentSlot.MAINHAND, (ItemStack)e));
            this.addSlot("off", e -> this.isValid(EquipmentSlot.OFFHAND, (ItemStack)e));
            this.addSlot("head", e -> this.isValid(EquipmentSlot.HEAD, (ItemStack)e));
            this.addSlot("chest", e -> this.isValid(EquipmentSlot.CHEST, (ItemStack)e));
            this.addSlot("legs", e -> this.isValid(EquipmentSlot.LEGS, (ItemStack)e));
            this.addSlot("feet", e -> this.isValid(EquipmentSlot.FEET, (ItemStack)e));
            if (golem instanceof HumanoidGolemEntity) {
                this.addSlot("backup", e -> this.isValid(EquipmentSlot.MAINHAND, (ItemStack)e) || this.isValid(EquipmentSlot.OFFHAND, (ItemStack)e));
                this.addSlot("arrow", ItemStack::isStackable);
            }
        }
    }

    private boolean isValid(EquipmentSlot slot, ItemStack stack) {
        if (this.golem instanceof HumanoidGolemEntity && (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND)) {
            return true;
        }
        Set<EquipmentSlot> valids = this.getSlotForItem(stack);
        if (this.golem instanceof MetalGolemEntity && valids.contains(EquipmentSlot.MAINHAND) && (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND)) {
            return true;
        }
        return valids.contains(slot);
    }

    public boolean stillValid(Player player) {
        if (this.golem == null) {
            return false;
        }
        this.golem.inventoryTick = 5;
        return this.golem.isAlive() && !this.golem.isRemoved();
    }

    public PredSlot getAsPredSlot(String name, int i, int j) {
        return super.getAsPredSlot(name, i, j);
    }

    public ItemStack quickMoveStack(Player pl, int id) {
        if (this.golem != null) {
            ItemStack stack = ((Slot)this.slots.get(id)).getItem();
            if (id >= 36) {
                this.moveItemStackTo(stack, 0, 36, true);
            } else {
                Set<EquipmentSlot> es = this.getSlotForItem(stack);
                for (int i = 0; i < 6; ++i) {
                    if (!es.contains(this.equipmentSlots[i])) continue;
                    this.moveItemStackTo(stack, 36 + i, 37 + i, false);
                    break;
                }
            }
            this.container.setChanged();
        }
        return ItemStack.EMPTY;
    }

    public Set<EquipmentSlot> getSlotForItem(ItemStack stack) {
        if (!this.stillValid(this.inventory.player) || this.golem == null) {
            return Set.of();
        }
        if (!stack.getItem().canFitInsideContainerItems()) {
            return Set.of();
        }
        if (stack.getItem() instanceof GolemHolder) {
            return Set.of();
        }
        AbstractGolemEntity<?, ?> abstractGolemEntity = this.golem;
        if (abstractGolemEntity instanceof HumanoidGolemEntity) {
            HumanoidGolemEntity humanoidGolem = (HumanoidGolemEntity)abstractGolemEntity;
            GolemEquipEvent event = new GolemEquipEvent(humanoidGolem, stack);
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.canEquip()) {
                return Set.of(event.getSlot());
            }
        }
        GolemEquipItemEvent event = new GolemEquipItemEvent(this.golem, stack);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.canEquip()) {
            return Set.of(event.getSlot());
        }
        return Set.of();
    }
}

