/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.wand;

import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemEntity;
import dev.xkmc.modulargolems.content.item.card.ConfigCard;
import dev.xkmc.modulargolems.content.item.wand.BaseWandItem;
import dev.xkmc.modulargolems.content.item.wand.GolemInteractItem;
import dev.xkmc.modulargolems.init.data.MGLangData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RiderWandItem
extends BaseWandItem
implements GolemInteractItem {
    public RiderWandItem(Item.Properties properties, @Nullable ItemEntry<? extends BaseWandItem> base) {
        super(properties, MGLangData.WAND_RIDER, null, base);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player user, LivingEntity target, InteractionHand hand) {
        if (user.getVehicle() instanceof AbstractGolemEntity) {
            if (!user.level().isClientSide()) {
                user.stopRiding();
            }
            return InteractionResult.SUCCESS;
        }
        if (!(target instanceof AbstractGolemEntity)) {
            return InteractionResult.PASS;
        }
        AbstractGolemEntity golem = (AbstractGolemEntity)target;
        return RiderWandItem.ride(target.level(), user, (AbstractGolemEntity)((Object)Wrappers.cast((Object)((Object)golem)))) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        if (user.getVehicle() instanceof AbstractGolemEntity) {
            if (!level.isClientSide()) {
                user.stopRiding();
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private static boolean ride(Level level, Player user, AbstractGolemEntity<?, ?> golem) {
        if (!ConfigCard.getFilter(user).test(golem)) {
            return false;
        }
        if (!golem.canModify(user) && !(golem.getControllingPassenger() instanceof Player)) {
            return false;
        }
        if (level.isClientSide()) {
            return true;
        }
        if (golem instanceof DogGolemEntity) {
            DogGolemEntity e = (DogGolemEntity)golem;
            user.startRiding((Entity)e, false);
            return true;
        }
        return true;
    }
}

