/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.wand;

import dev.xkmc.l2library.content.raytrace.IGlowingTarget;
import dev.xkmc.l2library.content.raytrace.RayTraceUtil;
import dev.xkmc.modulargolems.content.capability.GolemTracker;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.hostile.HostileGolemRegistry;
import dev.xkmc.modulargolems.content.item.wand.GolemInteractItem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class HostileWandItem
extends Item
implements GolemInteractItem,
IGlowingTarget {
    private static final int RANGE = 64;

    public HostileWandItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (level.isClientSide() && selected && entity instanceof Player) {
            Player player = (Player)entity;
            RayTraceUtil.clientUpdateTarget((Player)player, (double)64.0);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        LivingEntity target;
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide() && (target = RayTraceUtil.serverGetTarget((Player)player)) != null) {
            this.interactLivingEntity(stack, player, target, hand);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public int getDistance(ItemStack itemStack) {
        return 64;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player user, LivingEntity target, InteractionHand hand) {
        if (target instanceof AbstractGolemEntity) {
            AbstractGolemEntity golem = (AbstractGolemEntity)target;
            if (user instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)user;
                if (!golem.isHostile()) {
                    if (golem.getOwner() == user || sp.getAbilities().instabuild) {
                        golem.untrack(GolemTracker.Status.OTHER_RETRIEVED, null);
                        golem.setOwnerUUID(HostileGolemRegistry.DEFAULT.uuid);
                    }
                } else if (sp.getAbilities().instabuild) {
                    golem.setOwnerUUID(sp.getUUID());
                }
            }
        } else {
            target.addTag("HostileGolemTarget");
        }
        return InteractionResult.SUCCESS;
    }
}

