/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.wand;

import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.l2library.content.raytrace.IGlowingTarget;
import dev.xkmc.l2library.content.raytrace.RayTraceUtil;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.modulargolems.compat.curio.CurioCompatRegistry;
import dev.xkmc.modulargolems.content.client.outline.BlockOutliner;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.mode.GolemMode;
import dev.xkmc.modulargolems.content.entity.mode.GolemModes;
import dev.xkmc.modulargolems.content.item.card.ConfigCard;
import dev.xkmc.modulargolems.content.item.wand.BaseWandItem;
import dev.xkmc.modulargolems.content.item.wand.GolemInteractItem;
import dev.xkmc.modulargolems.content.menu.equipment.EquipmentsMenuPvd;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.data.MGLangData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import org.jetbrains.annotations.Nullable;

public class CommandWandItem
extends BaseWandItem
implements GolemInteractItem,
IGlowingTarget {
    private static final int RANGE = 64;

    public CommandWandItem(Item.Properties properties, @Nullable ItemEntry<? extends BaseWandItem> base) {
        super(properties, MGLangData.WAND_COMMAND_RIGHT, MGLangData.WAND_COMMAND_SHIFT, base);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (level.isClientSide() && selected && entity instanceof Player) {
            AbstractGolemEntity golem;
            Player player = (Player)entity;
            RayTraceUtil.clientUpdateTarget((Player)player, (double)64.0);
            LivingEntity livingEntity = RayTraceUtil.serverGetTarget((Player)player);
            if (livingEntity instanceof AbstractGolemEntity && (golem = (AbstractGolemEntity)livingEntity).getMode() == GolemModes.ROUTE) {
                BlockOutliner.drawOutlines(player, golem.getPatrolList());
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        LivingEntity target;
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide() && (target = RayTraceUtil.serverGetTarget((Player)player)) != null) {
            this.interactLivingEntity(stack, player, target, hand);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public int getDistance(ItemStack itemStack) {
        return 64;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player user, LivingEntity target, InteractionHand hand) {
        if (!(target instanceof AbstractGolemEntity)) {
            if (user instanceof ServerPlayer) {
                OwnableEntity ownable;
                ServerPlayer sp = (ServerPlayer)user;
                if (target instanceof OwnableEntity && (ownable = (OwnableEntity)target).getOwner() == user) {
                    if (((Boolean)MGConfig.COMMON.allowEditCuriosForOthers.get()).booleanValue()) {
                        CurioCompatRegistry.tryOpen(sp, target);
                    }
                } else {
                    this.hurtEnemy(stack, target, (LivingEntity)user);
                }
            }
            return InteractionResult.SUCCESS;
        }
        AbstractGolemEntity golem = (AbstractGolemEntity)target;
        return CommandWandItem.command(target.level(), user, (AbstractGolemEntity)((Object)Wrappers.cast((Object)((Object)golem)))) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    private static boolean command(Level level, Player user, AbstractGolemEntity<?, ?> golem) {
        if (!ConfigCard.getFilter(user).test(golem)) {
            return false;
        }
        if (!golem.canModify(user)) {
            return false;
        }
        if (level.isClientSide()) {
            return true;
        }
        if (user.isShiftKeyDown()) {
            new EquipmentsMenuPvd(golem).open((ServerPlayer)user);
            return true;
        }
        GolemMode mode = GolemModes.nextMode(golem.getMode());
        golem.setMode(mode.getID(), mode.hasPos() ? golem.blockPosition() : BlockPos.ZERO);
        return true;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!(attacker instanceof Player)) {
            return false;
        }
        Player player = (Player)attacker;
        List list = target.level().getEntities(EntityTypeTest.forClass(AbstractGolemEntity.class), attacker.getBoundingBox().inflate(32.0), e -> true);
        int size = 0;
        for (AbstractGolemEntity e2 : list) {
            if (!ConfigCard.getFilter(player).test(e2)) {
                return false;
            }
            if (!e2.canModify(player)) {
                return false;
            }
            if (e2.getOwner() != attacker) continue;
            ++size;
            e2.resetTarget(target);
        }
        if (attacker instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)attacker;
            pl.sendSystemMessage((Component)MGLangData.CALL_ATTACK.get(size, target.getDisplayName()), true);
        }
        return false;
    }
}

