/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.golem;

import dev.xkmc.modulargolems.init.registrate.GolemItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class NBTAnalytic {
    public static void analyze(ItemStack stack, List<Component> list) {
        CustomData root = (CustomData)GolemItems.ENTITY.get(stack);
        if (root == null) {
            return;
        }
        CompoundTag entity = root.getUnsafe();
        list.add(NBTAnalytic.log(entity, "entity NBT", new String[0]));
        list.add(NBTAnalytic.log(entity, "equipment", "ArmorItems", "HandItems"));
        list.add(NBTAnalytic.log(entity, "golem data", "auto-serial"));
        list.add(NBTAnalytic.log(entity, "Capability", "ForgeCaps"));
        list.add(NBTAnalytic.log(entity, "Attribute", "Attributes"));
    }

    private static Component log(CompoundTag root, String name, String ... key) {
        int ans = 0;
        if (key.length == 0) {
            ans = root.sizeInBytes();
        } else {
            for (String str : key) {
                Tag tag = root.get(str);
                if (tag == null) continue;
                ans += tag.sizeInBytes();
            }
        }
        MutableComponent size = ans >= 1024 ? Component.literal((String)("" + (ans >> 10))).withStyle(ChatFormatting.AQUA).append(" kiB") : Component.literal((String)("" + ans)).withStyle(ChatFormatting.AQUA).append(" bytes");
        return Component.literal((String)(name + " size: ")).append((Component)size).withStyle(ChatFormatting.GRAY);
    }
}

