/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.golem;

import com.mojang.datafixers.util.Pair;
import com.tterrag.registrate.util.CreativeModeTabModifier;
import dev.xkmc.l2core.init.reg.simple.Val;
import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.capability.GolemConfigStorage;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.core.GolemStatType;
import dev.xkmc.modulargolems.content.core.GolemType;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.content.item.data.GolemConfigKey;
import dev.xkmc.modulargolems.content.item.data.GolemHolderMaterial;
import dev.xkmc.modulargolems.content.item.data.GolemIcon;
import dev.xkmc.modulargolems.content.item.data.GolemUpgrade;
import dev.xkmc.modulargolems.content.item.golem.FlagTest;
import dev.xkmc.modulargolems.content.item.golem.GolemEquipUtil;
import dev.xkmc.modulargolems.content.item.golem.NBTAnalytic;
import dev.xkmc.modulargolems.content.item.upgrade.IUpgradeItem;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.data.MGLangData;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GolemHolder<T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>>
extends Item {
    private final Val<GolemType<T, P>> type;

    public static ArrayList<GolemMaterial> getMaterial(ItemStack stack) {
        GolemHolderMaterial ans = (GolemHolderMaterial)GolemItems.HOLDER_MAT.get(stack);
        return ans == null ? new ArrayList<GolemMaterial>() : ans.toList();
    }

    @Nullable
    public static Ingredient getCraftingMaterial(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof GolemHolder)) {
            return null;
        }
        GolemHolder holder = (GolemHolder)item;
        ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(stack);
        GolemType type = holder.getEntityType();
        Object part = type.getBodyPart();
        if (mats.size() <= part.ordinal()) {
            return null;
        }
        GolemMaterial mat = mats.get(part.ordinal());
        return GolemMaterialConfig.get().getCraftIngredient(mat.id());
    }

    @Nullable
    public static Ingredient getHealingMaterial(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof GolemHolder)) {
            return null;
        }
        GolemHolder holder = (GolemHolder)item;
        ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(stack);
        GolemType type = holder.getEntityType();
        Object part = type.getBodyPart();
        if (mats.size() <= part.ordinal()) {
            return null;
        }
        GolemMaterial mat = mats.get(part.ordinal());
        return GolemMaterialConfig.get().getRepairIngredient(mat.id());
    }

    public static GolemUpgrade getUpgrades(ItemStack stack) {
        return (GolemUpgrade)GolemItems.UPGRADE.getOrDefault(stack, (Object)GolemUpgrade.EMPTY);
    }

    public static Optional<GolemConfigKey> getGolemConfig(ItemStack stack) {
        return Optional.ofNullable((GolemConfigKey)GolemItems.CONFIG_KEY.get(stack));
    }

    public static void setGolemConfig(ItemStack stack, UUID id, int color) {
        GolemItems.CONFIG_KEY.set(stack, (Object)new GolemConfigKey(id, color));
    }

    public static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> ItemStack setEntity(T entity) {
        GolemHolder holder = GolemType.getGolemHolder(entity.getType());
        ItemStack stack = new ItemStack(holder);
        GolemConfigEntry config = entity.getConfigEntry(null);
        if (config != null) {
            GolemHolder.setGolemConfig(stack, config.getID(), config.getColor());
        }
        GolemItems.HOLDER_MAT.set(stack, (Object)GolemHolderMaterial.parse(entity.getMaterials()));
        GolemItems.UPGRADE.set(stack, (Object)entity.getUpgrades());
        CustomData.update((DataComponentType)((DataComponentType)GolemItems.ENTITY.get()), (ItemStack)stack, arg_0 -> entity.save(arg_0));
        Optional.ofNullable(entity.getCustomName()).ifPresent(e -> stack.set(DataComponents.CUSTOM_NAME, e));
        return stack;
    }

    public static float getHealth(ItemStack stack) {
        return Optional.ofNullable((CustomData)stack.get(GolemItems.ENTITY)).map(e -> e.getUnsafe()).map(e -> Float.valueOf(e.getFloat("Health"))).orElse(Float.valueOf(-1.0f)).floatValue();
    }

    public static float getMaxHealth(ItemStack stack) {
        Optional<CustomData> entity = Optional.ofNullable((CustomData)stack.get(GolemItems.ENTITY));
        if (entity.isPresent()) {
            for (Tag e : entity.get().getUnsafe().getList("attributes", 10)) {
                CompoundTag t;
                if (!(e instanceof CompoundTag) || !(t = (CompoundTag)e).getString("id").equals("minecraft:generic.max_health")) continue;
                AttributeInstance ins = new AttributeInstance(Attributes.MAX_HEALTH, x -> {});
                ins.load(t);
                return (float)ins.getValue();
            }
        }
        return -1.0f;
    }

    public static int getReforge(ItemStack stack) {
        return Optional.ofNullable((CustomData)stack.get(GolemItems.ENTITY)).map(e -> e.getUnsafe().getCompound("NeoForgeData").getInt("GolemReforge")).orElse(0);
    }

    public static void setReforge(ItemStack stack, int reforge) {
        Optional<CustomData> entity = Optional.ofNullable((CustomData)stack.get(GolemItems.ENTITY));
        if (entity.isPresent()) {
            CompoundTag tag = entity.get().getUnsafe();
            tag.getCompound("NeoForgeData").putInt("GolemReforge", reforge);
            for (Tag e : tag.getList("attributes", 10)) {
                CompoundTag t;
                if (!(e instanceof CompoundTag) || !(t = (CompoundTag)e).getString("id").equals("minecraft:generic.max_health")) continue;
                t.getList("modifiers", 10).removeIf(x -> {
                    CompoundTag comp;
                    return x instanceof CompoundTag && (comp = (CompoundTag)x).getString("id").equals(AbstractGolemEntity.REFORGE_ID.toString());
                });
            }
        }
    }

    public static void setHealth(ItemStack result, float health) {
        CustomData.update((DataComponentType)((DataComponentType)GolemItems.ENTITY.get()), (ItemStack)result, e -> e.putFloat("Health", health));
    }

    public static ItemStack toEntityIcon(ItemStack golem, ItemStack ... equipments) {
        return GolemItems.DC_ICON.set(golem, (Object)new GolemIcon(new ArrayList<ItemStack>(List.of(equipments))));
    }

    public ItemStack toEntityWithItem(ItemStack golem, ItemStack ... equipments) {
        GolemEquipUtil ctx = new GolemEquipUtil(false, null);
        for (ItemStack e : equipments) {
            ItemStack ans = ctx.applyItemOnHolder(this, golem, e);
            if (ans.isEmpty()) continue;
            golem = ans;
        }
        return golem;
    }

    public GolemHolder(Item.Properties props, Val<GolemType<T, P>> type) {
        super(props.stacksTo(1));
        this.type = type;
        GolemType.GOLEM_TYPE_TO_ITEM.put(type.id(), this);
    }

    public float getInvHeal(ItemStack stack, Entity entity) {
        float maxHealth;
        CustomData data = (CustomData)GolemItems.ENTITY.get(stack);
        if (data == null) {
            return 0.0f;
        }
        float health = GolemHolder.getHealth(stack);
        if (health < (maxHealth = GolemHolder.getMaxHealth(stack))) {
            ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(stack);
            GolemUpgrade upgrades = GolemHolder.getUpgrades(stack);
            Map<Holder<Attribute>, Pair<GolemStatType, Double>> attr = GolemMaterial.collectAttributes(mats, upgrades);
            HashMap<GolemModifier, Integer> modifiers = GolemMaterial.collectModifiers(mats, upgrades);
            if (health <= 0.0f) {
                FlagTest test = new FlagTest(GolemFlags.REVIVE);
                for (Map.Entry<GolemModifier, Integer> entry : modifiers.entrySet()) {
                    entry.getKey().onRegisterFlag(test);
                }
                if (!test.matched()) {
                    return 0.0f;
                }
            }
            double heal = (Double)attr.getOrDefault(GolemTypes.GOLEM_REGEN.holder(), (Pair<GolemStatType, Double>)Pair.of((Object)((Object)((GolemStatType)((Object)GolemTypes.STAT_REGEN.get()))), (Object)0.0)).getSecond();
            GolemModifier.HealingContext ctx = new GolemModifier.HealingContext(health, maxHealth, entity);
            for (Map.Entry<GolemModifier, Integer> entry : modifiers.entrySet()) {
                heal = entry.getKey().onInventoryHealTick(heal, ctx, entry.getValue());
            }
            if (heal > 0.0) {
                return Math.min(maxHealth, (float)heal + health) - health;
            }
        }
        return 0.0f;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (entity.tickCount % 20 == 0) {
            float health = GolemHolder.getHealth(stack);
            float heal = this.getInvHeal(stack, entity);
            if (heal > 0.0f) {
                GolemHolder.setHealth(stack, health + heal);
            }
        }
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        Vec3 pos;
        Level level = player.level();
        if (this.summon(stack, level, pos = target.position(), player, e -> e.checkRide(target))) {
            if (!level.isClientSide()) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public boolean canGrindstoneRepair(ItemStack stack) {
        return true;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState blockstate = level.getBlockState(blockpos);
        BlockPos spawnPos = blockstate.getCollisionShape((BlockGetter)level, blockpos).isEmpty() ? blockpos : blockpos.relative(direction);
        Vec3 pos = new Vec3((double)spawnPos.getX() + 0.5, (double)spawnPos.getY() + 0.05, (double)spawnPos.getZ() + 0.5);
        if (this.summon(stack, level, pos, context.getPlayer(), null)) {
            if (context.getPlayer() != null && !context.getLevel().isClientSide()) {
                context.getPlayer().setItemInHand(context.getHand(), ItemStack.EMPTY);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    private static void setPos(Level level, AbstractGolemEntity<?, ?> golem, Vec3 pos) {
        double y;
        double xz;
        golem.setPos(pos);
        EntityDimensions dim = golem.getDimensions(Pose.STANDING);
        if (dim.width() * dim.width() * dim.height() > 64.0f) {
            return;
        }
        Vec3 vec3 = golem.position().add(0.0, (double)dim.height() / 2.0, 0.0);
        VoxelShape voxelshape = Shapes.create((AABB)AABB.ofSize((Vec3)vec3, (double)(xz = (double)(dim.width() - 1.0f) + 1.0E-6), (double)(y = (double)(dim.height() - 1.0f) + 1.0E-6), (double)xz));
        Optional opt = level.findFreePosition(golem, voxelshape, vec3, (double)dim.width(), (double)dim.height(), (double)dim.width());
        if (opt.isPresent()) {
            pos = ((Vec3)opt.get()).add(0.0, (double)(-dim.height()) / 2.0, 0.0);
        }
        golem.setPos(pos);
    }

    public boolean summon(ItemStack stack, Level level, Vec3 pos, @Nullable Player player, @Nullable Consumer<AbstractGolemEntity<?, ?>> callback) {
        CustomData data = (CustomData)GolemItems.ENTITY.get(stack);
        if (data != null && GolemHolder.getMaxHealth(stack) >= 0.0f) {
            if (GolemHolder.getHealth(stack) <= 0.0f) {
                return false;
            }
            if (!level.isClientSide()) {
                Object golem = ((GolemType)((Object)this.type.get())).create((ServerLevel)level, data.getUnsafe());
                UUID id = player == null ? null : player.getUUID();
                ((AbstractGolemEntity)((Object)golem)).updateAttributes(GolemHolder.getMaterial(stack), GolemHolder.getUpgrades(stack), id);
                GolemHolder.setPos(level, golem, pos);
                GolemHolder.getGolemConfig(stack).ifPresent(e -> golem.setConfigCard(e.id(), e.color()));
                Optional.ofNullable((Component)stack.get(DataComponents.CUSTOM_NAME)).ifPresent(arg_0 -> golem.setCustomName(arg_0));
                if (!((AbstractGolemEntity)((Object)golem)).initMode(player)) {
                    return false;
                }
                level.addFreshEntity(golem);
                stack.remove(GolemItems.ENTITY);
                stack.shrink(1);
                if (callback != null) {
                    callback.accept((AbstractGolemEntity<?, ?>)((Object)golem));
                }
            }
            return true;
        }
        GolemHolderMaterial mat = (GolemHolderMaterial)GolemItems.HOLDER_MAT.get(stack);
        if (mat != null) {
            if (!level.isClientSide()) {
                Object golem = ((GolemType)((Object)this.type.get())).create(level);
                GolemHolder.setPos(level, golem, pos);
                UUID id = player == null ? null : player.getUUID();
                ((AbstractGolemEntity)((Object)golem)).onCreate(GolemHolder.getMaterial(stack), GolemHolder.getUpgrades(stack), id);
                GolemHolder.getGolemConfig(stack).ifPresent(e -> golem.setConfigCard(e.id(), e.color()));
                GolemEquipUtil.addItemsToGolem(golem, stack, true);
                Optional.ofNullable((Component)stack.get(DataComponents.CUSTOM_NAME)).ifPresent(arg_0 -> golem.setCustomName(arg_0));
                if (!((AbstractGolemEntity)((Object)golem)).initMode(player)) {
                    return false;
                }
                level.addFreshEntity(golem);
                if (player == null || !player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                if (callback != null) {
                    callback.accept((AbstractGolemEntity<?, ?>)((Object)golem));
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public T createDummy(ItemStack stack, Level level) {
        Object golem;
        CustomData data = (CustomData)GolemItems.ENTITY.get(stack);
        GolemHolderMaterial mat = (GolemHolderMaterial)GolemItems.HOLDER_MAT.get(stack);
        if (data != null) {
            golem = ((GolemType)((Object)this.type.get())).create((ServerLevel)level, data.getUnsafe());
            ((AbstractGolemEntity)((Object)golem)).updateAttributes(GolemHolder.getMaterial(stack), GolemHolder.getUpgrades(stack), null);
        } else if (mat != null) {
            golem = ((GolemType)((Object)this.type.get())).create(level);
            ((AbstractGolemEntity)((Object)golem)).onCreate(GolemHolder.getMaterial(stack), GolemHolder.getUpgrades(stack), null);
            GolemEquipUtil.addItemsToGolem(golem, stack, true);
        } else {
            return null;
        }
        GolemHolder.getGolemConfig(stack).ifPresent(e -> golem.setConfigCard(e.id(), e.color()));
        Optional.ofNullable((Component)stack.get(DataComponents.CUSTOM_NAME)).ifPresent(arg_0 -> golem.setCustomName(arg_0));
        return golem;
    }

    public boolean isBarVisible(ItemStack stack) {
        if (GolemItems.DC_DISP_HP.get(stack) != null) {
            return true;
        }
        return GolemHolder.getMaxHealth(stack) >= 0.0f;
    }

    public int getBarColor(ItemStack stack) {
        float f;
        Double hp = (Double)GolemItems.DC_DISP_HP.get(stack);
        if (hp != null) {
            f = hp.floatValue();
        } else {
            float health = GolemHolder.getHealth(stack);
            float maxHealth = GolemHolder.getMaxHealth(stack);
            f = Mth.clamp((float)(health / maxHealth), (float)0.0f, (float)1.0f);
        }
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public int getBarWidth(ItemStack stack) {
        Double hp = (Double)GolemItems.DC_DISP_HP.get(stack);
        if (hp != null) {
            return Math.round(hp.floatValue() * 13.0f);
        }
        return Math.round(Mth.clamp((float)(GolemHolder.getHealth(stack) / GolemHolder.getMaxHealth(stack)), (float)0.0f, (float)1.0f) * 13.0f);
    }

    public GolemType<T, P> getEntityType() {
        return (GolemType)((Object)this.type.get());
    }

    public void fillItemCategory(CreativeModeTabModifier tab) {
        for (ResourceLocation rl : GolemMaterialConfig.get().getAllMaterials()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            ArrayList<GolemHolderMaterial.Entry> mats = new ArrayList<GolemHolderMaterial.Entry>();
            for (IGolemPart part : this.getEntityType().values()) {
                mats.add(new GolemHolderMaterial.Entry(part.toItem(), rl));
            }
            tab.accept(GolemItems.HOLDER_MAT.set(stack, (Object)new GolemHolderMaterial(mats)));
        }
    }

    public ItemStack withUniformMaterial(ResourceLocation rl) {
        ItemStack stack = new ItemStack((ItemLike)this);
        ArrayList<GolemHolderMaterial.Entry> list = new ArrayList<GolemHolderMaterial.Entry>();
        for (IGolemPart part : this.getEntityType().values()) {
            list.add(new GolemHolderMaterial.Entry(part.toItem(), rl));
        }
        return GolemItems.HOLDER_MAT.set(stack, (Object)new GolemHolderMaterial(list));
    }

    public int getRemaining(ArrayList<GolemMaterial> mats, GolemUpgrade upgrades) {
        int base = this.getEntityType().values().length;
        if (this.type.get() == GolemTypes.TYPE_GOLEM.get()) {
            base = (Integer)MGConfig.COMMON.largeGolemSlot.get();
        } else if (this.type.get() == GolemTypes.TYPE_HUMANOID.get()) {
            base = (Integer)MGConfig.COMMON.humanoidGolemSlot.get();
        } else if (this.type.get() == GolemTypes.TYPE_DOG.get()) {
            base = (Integer)MGConfig.COMMON.dogGolemSlot.get();
        }
        base = base + upgrades.extraSlot() - upgrades.size();
        HashMap<GolemModifier, Integer> modifiers = GolemMaterial.collectModifiers(mats, upgrades);
        List<IUpgradeItem> list = upgrades.upgradeItems();
        for (Map.Entry<GolemModifier, Integer> ent : modifiers.entrySet()) {
            base += ent.getKey().addSlot(list, ent.getValue());
        }
        return base;
    }

    public void onDestroyed(ItemEntity entity, DamageSource source) {
        if (source.is(DamageTypeTags.IS_EXPLOSION)) {
            for (Item e : GolemHolder.getUpgrades(entity.getItem()).upgrades()) {
                entity.level().addFreshEntity((Entity)new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), e.getDefaultInstance()));
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        if (flag.hasAltDown()) {
            NBTAnalytic.analyze(stack, list);
            return;
        }
        Level level = ctx.level();
        if (!flag.hasShiftDown()) {
            int reforge;
            float max = GolemHolder.getMaxHealth(stack);
            if (max >= 0.0f) {
                float health = GolemHolder.getHealth(stack);
                float f = Mth.clamp((float)(health / max), (float)0.0f, (float)1.0f);
                int color = Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
                MutableComponent hc = Component.literal((String)("" + Math.round(health))).setStyle(Style.EMPTY.withColor(color));
                list.add((Component)MGLangData.HEALTH.get(hc, Math.round(max)).withStyle(health <= 0.0f ? ChatFormatting.RED : ChatFormatting.AQUA));
            }
            if ((reforge = GolemHolder.getReforge(stack)) > 0) {
                list.add((Component)MGLangData.MELTDOWN.get(reforge));
            }
            Optional<GolemConfigKey> config = GolemHolder.getGolemConfig(stack);
            if (level == null || config.isEmpty()) {
                list.add((Component)MGLangData.NO_CONFIG.get(new Object[0]));
            } else {
                UUID id = config.get().id();
                int color = config.get().color();
                GolemConfigEntry entry = GolemConfigStorage.get(level).getOrCreateStorage(id, color, (Component)MGLangData.LOADING.get(new Object[0]));
                entry.clientTick(level, false);
                list.add(entry.getDisplayName());
            }
            ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(stack);
            GolemUpgrade upgrades = GolemHolder.getUpgrades(stack);
            IGolemPart[] parts = this.getEntityType().values();
            if (mats.size() == parts.length) {
                for (int i = 0; i < parts.length; ++i) {
                    list.add((Component)parts[i].getDesc(mats.get(i).getDesc()));
                }
            }
            list.add((Component)MGLangData.SLOT.get(this.getRemaining(mats, upgrades)).withStyle(ChatFormatting.AQUA));
            HashMap<GolemModifier, Integer> modifiers = GolemMaterial.collectModifiers(mats, upgrades);
            if (modifiers.size() > 8) {
                list.add((Component)MGLangData.UPGRADE_COUNT.get(modifiers.size(), upgrades.size()));
            } else {
                modifiers.forEach((k, v) -> list.add(k.getTooltip((int)v)));
            }
            GolemMaterial.collectAttributes(mats, upgrades).forEach((k, v) -> {
                if (Math.abs((Double)v.getSecond()) > 0.001) {
                    list.add((Component)((GolemStatType)((Object)((Object)v.getFirst()))).getTotalTooltip((Double)v.getSecond()));
                }
            });
            list.add((Component)MGLangData.SHIFT.get(new Object[0]));
        } else {
            ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(stack);
            GolemUpgrade upgrades = GolemHolder.getUpgrades(stack);
            HashMap<GolemModifier, Integer> map = GolemMaterial.collectModifiers(mats, upgrades);
            int size = map.size();
            int index = 0;
            for (Map.Entry<GolemModifier, Integer> entry : map.entrySet()) {
                GolemModifier k2 = entry.getKey();
                Integer v2 = entry.getValue();
                list.add(k2.getTooltip(v2));
                if (size > 12 || size > 4 && level != null && level.getGameTime() / 30L % (long)size != (long)(++index - 1)) continue;
                list.addAll(k2.getDetail(v2));
            }
        }
    }
}

