/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.golem;

import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.item.card.ConfigCard;
import dev.xkmc.modulargolems.content.item.data.GolemEquipments;
import dev.xkmc.modulargolems.content.item.equipments.GolemEquipmentItem;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.item.upgrade.UpgradeItem;
import dev.xkmc.modulargolems.events.CraftEventListeners;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public record GolemEquipUtil(boolean isClient, @Nullable Level level) {
    private static boolean isGolemCurio(GolemHolder<?, ?> holder, ItemStack stack) {
        if (!ModList.get().isLoaded("curios")) {
            return false;
        }
        Set set = CuriosApi.getEntitySlots(holder.getEntityType().type(), (boolean)false).keySet();
        for (String e : set) {
            if (!stack.is(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)e)))) continue;
            return true;
        }
        return false;
    }

    private EquipmentSlot getSlot(ItemStack item, GolemHolder<?, ?> holder, ItemStack golem) {
        if (this.level == null) {
            EquipmentSlot ans = item.getEquipmentSlot();
            if (ans == null) {
                return EquipmentSlot.MAINHAND;
            }
            return ans;
        }
        return holder.createDummy(golem, this.level).getEquipmentSlotForItem(item);
    }

    public ItemStack applyItemOnHolder(GolemHolder<?, ?> holder, ItemStack first, ItemStack second) {
        EquipmentSlot slot;
        Object id;
        Item item = second.getItem();
        if (item instanceof ConfigCard) {
            ConfigCard card = (ConfigCard)item;
            id = ConfigCard.getUUID(second);
            if (id == null) {
                return ItemStack.EMPTY;
            }
            ItemStack result = first.copy();
            GolemHolder.setGolemConfig(result, (UUID)id, card.getColor().ordinal());
            return result;
        }
        id = second.getItem();
        if (id instanceof UpgradeItem) {
            UpgradeItem upgrade = (UpgradeItem)id;
            return CraftEventListeners.appendUpgrade(first, holder, upgrade);
        }
        if (GolemEquipUtil.isGolemCurio(holder, second)) {
            return this.equipCurioOnHolder(holder, first, second);
        }
        if (holder.getEntityType() == GolemTypes.TYPE_GOLEM.get()) {
            if (!second.is(MGTagGen.LARGE_GOLEM_WEAPONS)) {
                Item item2 = second.getItem();
                if (!(item2 instanceof GolemEquipmentItem)) {
                    return ItemStack.EMPTY;
                }
                GolemEquipmentItem equipment = (GolemEquipmentItem)item2;
                if (!equipment.isFor((EntityType)GolemTypes.ENTITY_GOLEM.get())) {
                    return ItemStack.EMPTY;
                }
                slot = equipment.getSlot();
            } else {
                slot = this.getSlot(second, holder, first);
            }
            return this.equipOnHolder(holder, first, second, slot);
        }
        if (holder.getEntityType() == GolemTypes.TYPE_HUMANOID.get()) {
            slot = this.getSlot(second, holder, first);
            return this.equipOnHolder(holder, first, second, slot);
        }
        return ItemStack.EMPTY;
    }

    public <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> ItemStack equipCurioOnHolder(GolemHolder<T, P> holder, ItemStack golem, ItemStack equip) {
        T entity;
        if (this.level == null) {
            return ItemStack.EMPTY;
        }
        if (!ModList.get().isLoaded("curios")) {
            return ItemStack.EMPTY;
        }
        if (!golem.has((DataComponentType)GolemItems.ENTITY.get())) {
            GolemEquipments equipments = ((GolemEquipments)GolemItems.EQUIPMENTS.getOrDefault(golem, (Object)new GolemEquipments())).copy();
            Set golemSlots = CuriosApi.getEntitySlots(holder.getEntityType().type(), (boolean)this.isClient).keySet();
            LinkedHashSet itemSlots = new LinkedHashSet(CuriosApi.getItemStackSlots((ItemStack)equip, (boolean)this.isClient).keySet());
            itemSlots.retainAll(golemSlots);
            for (String slot : itemSlots) {
                if (equipments.equipments().containsKey(slot)) continue;
                equipments.equipments().put(slot, equip.copy());
                GolemItems.EQUIPMENTS.set(golem, (Object)equipments);
                return golem;
            }
        }
        if ((entity = holder.createDummy(golem, this.level)) == null) {
            return ItemStack.EMPTY;
        }
        Optional opt = CuriosApi.getCuriosInventory(entity);
        if (opt.isEmpty()) {
            return ItemStack.EMPTY;
        }
        equip = equip.copy();
        equip.setCount(1);
        for (String slot : CuriosApi.getItemStackSlots((ItemStack)equip, entity).keySet()) {
            Optional handler = ((ICuriosItemHandler)opt.get()).getStacksHandler(slot);
            if (handler.isEmpty()) continue;
            IDynamicStackHandler stacks = ((ICurioStacksHandler)handler.get()).getStacks();
            for (int i = 0; i < stacks.getSlots(); ++i) {
                if (!stacks.getStackInSlot(i).isEmpty()) continue;
                stacks.setStackInSlot(i, equip);
                return GolemHolder.setEntity(entity);
            }
        }
        return ItemStack.EMPTY;
    }

    public <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> ItemStack equipOnHolder(GolemHolder<T, P> holder, ItemStack golem, ItemStack equip, EquipmentSlot slot) {
        GolemEquipments equipments;
        if (!golem.has((DataComponentType)GolemItems.ENTITY.get()) && !(equipments = ((GolemEquipments)GolemItems.EQUIPMENTS.getOrDefault(golem, (Object)new GolemEquipments())).copy()).equipments().containsKey(slot.name())) {
            equipments.equipments().put(slot.name(), equip.copy());
            GolemItems.EQUIPMENTS.set(golem, (Object)equipments);
            return golem;
        }
        if (this.level == null) {
            return ItemStack.EMPTY;
        }
        T entity = holder.createDummy(golem, this.level);
        if (entity == null) {
            return ItemStack.EMPTY;
        }
        if (!entity.getItemBySlot(slot).isEmpty()) {
            return ItemStack.EMPTY;
        }
        equip = equip.copy();
        equip.setCount(1);
        entity.setItemSlot(slot, equip);
        return GolemHolder.setEntity(entity);
    }

    public static boolean giveItemToGolem(AbstractGolemEntity<?, ?> golem, ItemStack item, String ent) {
        try {
            EquipmentSlot slot = Enum.valueOf(EquipmentSlot.class, ent);
            golem.setItemSlot(slot, item);
            return true;
        }
        catch (Exception exception) {
            if (!ModList.get().isLoaded("curios")) {
                return false;
            }
            return GolemEquipUtil.giveCurioToGolem(golem, item, ent);
        }
    }

    public static boolean giveCurioToGolem(AbstractGolemEntity<?, ?> golem, ItemStack item, String ent) {
        Optional opt = CuriosApi.getCuriosInventory(golem);
        if (opt.isEmpty()) {
            return false;
        }
        Optional handler = ((ICuriosItemHandler)opt.get()).getStacksHandler(ent);
        if (handler.isEmpty()) {
            return false;
        }
        IDynamicStackHandler stacks = ((ICurioStacksHandler)handler.get()).getStacks();
        for (int i = 0; i < stacks.getSlots(); ++i) {
            if (!stacks.getStackInSlot(i).isEmpty()) continue;
            stacks.setStackInSlot(i, item);
            return true;
        }
        return false;
    }

    public static void addItemsToGolem(AbstractGolemEntity<?, ?> golem, ItemStack root, boolean dropExtra) {
        GolemEquipments equipMap = (GolemEquipments)GolemItems.EQUIPMENTS.get(root);
        if (equipMap != null) {
            for (Map.Entry<String, ItemStack> ent : equipMap.equipments().entrySet()) {
                ItemStack item = ent.getValue();
                if (GolemEquipUtil.giveItemToGolem(golem, item, ent.getKey()) || !dropExtra) continue;
                golem.spawnAtLocation(item);
            }
        }
    }
}

