/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.golem;

import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.item.data.GolemIcon;
import dev.xkmc.modulargolems.content.item.golem.GolemEquipUtil;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import io.netty.util.collection.IntObjectHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(value={Dist.CLIENT}, modid="modulargolems", bus=EventBusSubscriber.Bus.GAME)
public class ClientHolderManager {
    private static final int LIFE = 200;
    private static final IntObjectHashMap<TimedCache> CACHE = new IntObjectHashMap();

    @SubscribeEvent
    public static void tickEvent(ClientTickEvent.Post event) {
        if (CACHE.size() > 100) {
            ModularGolems.LOGGER.error("Golem cache overflow. Clearing...");
            CACHE.clear();
        } else {
            CACHE.entrySet().removeIf(e -> ((TimedCache)e.getValue()).life-- <= 0);
        }
    }

    @Nullable
    public static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> T getEntityForDisplay(GolemHolder<T, P> holder, ItemStack stack) {
        CustomData data = (CustomData)GolemItems.ENTITY.get(stack);
        GolemIcon icon = (GolemIcon)GolemItems.DC_ICON.get(stack);
        if (data == null && icon == null) {
            return null;
        }
        int hash = stack.hashCode();
        if (CACHE.containsKey(hash)) {
            AbstractGolemEntity<?, ?> ans = ((TimedCache)ClientHolderManager.CACHE.get((int)stack.hashCode())).entity;
            return (T)((Object)(ans == null ? null : (AbstractGolemEntity)((Object)Wrappers.cast(ans))));
        }
        T golem = ClientHolderManager.getEntityForDisplayInternal(holder, stack);
        TimedCache cache = new TimedCache(200, (AbstractGolemEntity<?, ?>)((Object)golem));
        CACHE.put(hash, (Object)cache);
        return golem;
    }

    @Nullable
    private static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> T getEntityForDisplayInternal(GolemHolder<T, P> holder, ItemStack stack) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        AbstractGolemEntity ans = null;
        CustomData data = (CustomData)GolemItems.ENTITY.get(stack);
        GolemIcon icon = (GolemIcon)GolemItems.DC_ICON.get(stack);
        if (data != null) {
            ans = (AbstractGolemEntity)((Object)holder.getEntityType().createForDisplay((Level)level, data.getUnsafe()));
            if (ans != null) {
                ans.onCreate(GolemHolder.getMaterial(stack), GolemHolder.getUpgrades(stack), null);
            }
        } else if (icon != null) {
            T golem = holder.getEntityType().create((Level)level);
            golem.addTag("ClientOnly");
            ((AbstractGolemEntity)((Object)golem)).onCreate(GolemHolder.getMaterial(stack), GolemHolder.getUpgrades(stack), null);
            GolemEquipUtil.addItemsToGolem(golem, stack, false);
            for (ItemStack e : icon.list()) {
                golem.equipItemIfPossible(e);
            }
            ans = (AbstractGolemEntity)((Object)Wrappers.cast(golem));
        }
        if (ans == null) {
            return null;
        }
        ans.hurtTime = 0;
        return (T)((Object)ans);
    }

    static final class TimedCache {
        @Nullable
        private final AbstractGolemEntity<?, ?> entity;
        private int life;

        TimedCache(int life, @Nullable AbstractGolemEntity<?, ?> entity) {
            this.life = life;
            this.entity = entity;
        }
    }
}

