/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.equipments;

import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import dev.xkmc.modulargolems.content.item.equipments.CustomDropGolemWeapon;
import dev.xkmc.modulargolems.content.item.equipments.MetalGolemWeaponItem;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.data.MGLangData;
import dev.xkmc.modulargolems.init.data.RecipeGen;
import dev.xkmc.modulargolems.init.material.GolemWeaponType;
import dev.xkmc.modulargolems.init.material.VanillaGolemWeaponMaterial;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class SlicingAxe
extends MetalGolemWeaponItem
implements CustomDropGolemWeapon {
    public SlicingAxe(Item.Properties properties, int attackDamage, double percentAttack, float range, float sweep) {
        super(properties, attackDamage, percentAttack, range, sweep);
    }

    @Override
    public boolean dropCustomDeathLoot(AbstractGolemEntity<?, ?> self, MetalGolemEntity attacker, ItemStack stack, DamageSource source) {
        block4: {
            RandomSource random;
            double rate;
            block3: {
                if (attacker.isHostile()) {
                    return false;
                }
                rate = (Double)MGConfig.COMMON.slicingDropUpgradeChance.get();
                random = self.getRandom();
                if (!self.isHostile()) break block3;
                ArrayList<GolemMaterial> mats = self.getMaterials();
                GolemMaterial mat = mats.get(random.nextInt(mats.size()));
                self.spawnAtLocation(GolemPart.setMaterial(mat.part().getDefaultInstance(), mat.id()));
                ArrayList<Item> upgrades = self.getUpgrades().upgrades();
                if (upgrades.isEmpty()) break block4;
                Item upgrade = upgrades.get(random.nextInt(upgrades.size()));
                if (!((double)random.nextFloat() < rate)) break block4;
                self.spawnAtLocation(upgrade.getDefaultInstance());
                break block4;
            }
            for (GolemMaterial mat : self.getMaterials()) {
                self.spawnAtLocation(GolemPart.setMaterial(mat.part().getDefaultInstance(), mat.id()));
            }
            for (Item e : self.getUpgrades().upgrades()) {
                if (!((double)random.nextFloat() < rate)) continue;
                self.spawnAtLocation(e.getDefaultInstance());
            }
        }
        return true;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        list.add((Component)MGLangData.SLICING_GOLEM.get(Math.round((Double)MGConfig.COMMON.slicingDropUpgradeChance.get() * 100.0) + "%"));
        list.add((Component)MGLangData.SLICING_ENEMY.get(new Object[0]));
        super.appendHoverText(stack, level, list, flag);
    }

    public static ItemEntry<SlicingAxe> buildItem(String id, VanillaGolemWeaponMaterial material) {
        return ModularGolems.REGISTRATE.item(id, p -> new SlicingAxe(material.modify(p.stacksTo(1)), 0, (double)material.getDamage() * 0.05, 0.0f, 2.0f)).model((ctx, pvd) -> ((ItemModelBuilder)((ItemModelBuilder)pvd.getBuilder(ctx.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc(GolemWeaponType.AXE.model)))).texture("layer0", pvd.modLoc("item/equipments/" + ctx.getName()))).tag(new TagKey[]{ItemTags.SWORD_ENCHANTABLE, ItemTags.SHARP_WEAPON_ENCHANTABLE}).recipe((ctx, pvd) -> RecipeGen.unlock(pvd, (arg_0, arg_1) -> ((SmithingTransformRecipeBuilder)SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{GolemItems.METALGOLEM_WEAPON[GolemWeaponType.AXE.ordinal()][VanillaGolemWeaponMaterial.DIAMOND.ordinal()]}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONECUTTER}), (RecipeCategory)RecipeCategory.COMBAT, (Item)((Item)ctx.get()))).unlocks(arg_0, arg_1), Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE).save((RecipeOutput)pvd, ctx.getName())).defaultLang().register();
    }
}

