/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.equipments;

import dev.xkmc.modulargolems.content.item.equipments.GolemEquipmentItem;
import dev.xkmc.modulargolems.content.item.equipments.GolemModelItem;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MetalGolemArmorItem
extends GolemEquipmentItem
implements GolemModelItem {
    private final ResourceLocation model;

    public MetalGolemArmorItem(Item.Properties properties, ArmorItem.Type type, int defense, float toughness, ResourceLocation model) {
        super(properties, type.getSlot(), () -> GolemTypes.ENTITY_GOLEM.get(), builder -> {
            ResourceLocation rl = ModularGolems.loc(type.getName() + "_armor");
            builder.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(rl, (double)defense, AttributeModifier.Operation.ADD_VALUE));
            builder.put((Object)Attributes.ARMOR_TOUGHNESS, (Object)new AttributeModifier(rl.withSuffix("_toughness"), (double)toughness, AttributeModifier.Operation.ADD_VALUE));
        });
        this.model = model;
    }

    protected String namespace(String def) {
        return def;
    }

    @Override
    public ResourceLocation getModelTexture() {
        ResourceLocation rl = BuiltInRegistries.ITEM.getKey((Object)this);
        return ResourceLocation.fromNamespaceAndPath((String)this.namespace(rl.getNamespace()), (String)("textures/equipments/" + rl.getPath() + ".png"));
    }

    @Override
    public ResourceLocation getEmissiveModelTexture() {
        ResourceLocation rl = BuiltInRegistries.ITEM.getKey((Object)this);
        return ResourceLocation.fromNamespaceAndPath((String)this.namespace(rl.getNamespace()), (String)("textures/equipments/" + rl.getPath() + "_emissive.png"));
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 15;
    }

    @Override
    public ResourceLocation getModelPath() {
        return this.model;
    }
}

