/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.equipments;

import com.google.common.collect.ImmutableMultimap;
import dev.xkmc.modulargolems.content.item.equipments.MetalGolemWeaponItem;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class HeavySpearItem
extends MetalGolemWeaponItem {
    private final int damage;

    public HeavySpearItem(Item.Properties properties, int attackDamage, double percentAttack, float range, float sweep) {
        super(properties, attackDamage, percentAttack, range, sweep);
        this.damage = attackDamage;
    }

    @Override
    protected void additionalAttributes(ImmutableMultimap.Builder<Holder<Attribute>, AttributeModifier> builder) {
    }

    public static boolean canSmashAttack(LivingEntity user) {
        return user.fallDistance > 1.5f && !user.isFallFlying();
    }

    public float getAttackDamageBonus(Entity target, float amount, DamageSource source) {
        Entity entity = source.getDirectEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity user = (LivingEntity)entity;
            if (!HeavySpearItem.canSmashAttack(user)) {
                return 0.0f;
            }
            float fall = user.fallDistance;
            float bonus = fall <= 3.0f ? 4.0f * fall : (fall <= 8.0f ? 12.0f + 2.0f * (fall - 3.0f) : 22.0f + fall - 8.0f);
            Level level = user.level();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                bonus += EnchantmentHelper.modifyFallBasedDamage((ServerLevel)sl, (ItemStack)user.getWeaponItem(), (Entity)target, (DamageSource)source, (float)0.0f) * fall;
            }
            return bonus * Math.max(1.0f, amount / (float)this.damage);
        }
        return 0.0f;
    }
}

