/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.equipments;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.xkmc.modulargolems.init.data.MGLangData;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public abstract class GolemEquipmentItem
extends Item {
    private final EquipmentSlot slot;
    private final Supplier<EntityType<?>> type;
    private final Multimap<Holder<Attribute>, AttributeModifier> defaultModifiers;

    public GolemEquipmentItem(Item.Properties properties, EquipmentSlot slot, Supplier<EntityType<?>> type, Consumer<ImmutableMultimap.Builder<Holder<Attribute>, AttributeModifier>> attr) {
        super(properties);
        this.slot = slot;
        this.type = type;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        attr.accept((ImmutableMultimap.Builder<Holder<Attribute>, AttributeModifier>)builder);
        this.additionalAttributes((ImmutableMultimap.Builder<Holder<Attribute>, AttributeModifier>)builder);
        this.defaultModifiers = builder.build();
    }

    protected void additionalAttributes(ImmutableMultimap.Builder<Holder<Attribute>, AttributeModifier> builder) {
    }

    public EquipmentSlot getSlot() {
        return this.slot;
    }

    public boolean isFor(EntityType<?> type) {
        return this.type.get() == type;
    }

    public void forEachModifier(ItemStack stack, Entity entity, EquipmentSlot slot, BiConsumer<Holder<Attribute>, AttributeModifier> action) {
        if (this.slot != slot) {
            return;
        }
        if (this.type.get() != entity.getType()) {
            return;
        }
        this.defaultModifiers.forEach(action);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        list.add((Component)MGLangData.GOLEM_EQUIPMENT.get(this.type.get().getDescription().copy().withStyle(ChatFormatting.GOLD)));
        Multimap<Holder<Attribute>, AttributeModifier> multimap = this.defaultModifiers;
        if (multimap.isEmpty()) {
            return;
        }
        list.add(CommonComponents.EMPTY);
        list.add((Component)Component.translatable((String)("item.modifiers." + this.slot.getName())).withStyle(ChatFormatting.GRAY));
        for (Map.Entry entry : multimap.entries()) {
            AttributeModifier attr = (AttributeModifier)entry.getValue();
            double val = attr.amount();
            double disp = attr.operation() == AttributeModifier.Operation.ADD_VALUE ? val : val * 100.0;
            if (val > 0.0) {
                list.add((Component)Component.translatable((String)("attribute.modifier.plus." + attr.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(disp), Component.translatable((String)((Attribute)((Holder)entry.getKey()).value()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                continue;
            }
            if (!(val < 0.0)) continue;
            list.add((Component)Component.translatable((String)("attribute.modifier.take." + attr.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(disp *= -1.0), Component.translatable((String)((Attribute)((Holder)entry.getKey()).value()).getDescriptionId())}).withStyle(ChatFormatting.RED));
        }
    }
}

