/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.data;

import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public record GolemHolderMaterial(ArrayList<Entry> parts) {
    public static GolemHolderMaterial parse(ArrayList<GolemMaterial> materials) {
        ArrayList<Entry> list = new ArrayList<Entry>();
        for (GolemMaterial mat : materials) {
            list.add(new Entry(mat.part(), mat.id()));
        }
        return new GolemHolderMaterial(list);
    }

    public ArrayList<GolemMaterial> toList() {
        ArrayList<GolemMaterial> list = new ArrayList<GolemMaterial>();
        for (Entry e : this.parts) {
            Item item = e.part;
            if (!(item instanceof GolemPart)) continue;
            GolemPart part = (GolemPart)item;
            list.add(part.parseMaterial(e.material()));
        }
        return list;
    }

    public int size() {
        return this.parts.size();
    }

    public ArrayList<Entry> copyParts() {
        return new ArrayList<Entry>(this.parts);
    }

    public record Entry(Item part, ResourceLocation material) {
    }
}

