/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.card;

import dev.xkmc.modulargolems.content.item.card.ClickEntityFilterCard;
import dev.xkmc.modulargolems.init.data.MGLangData;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class UuidFilterCard
extends ClickEntityFilterCard<UUID> {
    private static final String KEY = "idList";

    public UuidFilterCard(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected UUID getValue(LivingEntity entity) {
        return entity.getUUID();
    }

    @Override
    protected Component getName(UUID uuid) {
        return Component.literal((String)uuid.toString().substring(0, 8));
    }

    @Override
    public List<UUID> getList(ItemStack stack) {
        return new ArrayList<UUID>((Collection)GolemItems.DC_FILTER_UUID.getOrDefault(stack, Set.of()));
    }

    @Override
    public void setList(ItemStack stack, List<UUID> list) {
        if (list.isEmpty()) {
            stack.remove(GolemItems.DC_FILTER_UUID);
        } else {
            GolemItems.DC_FILTER_UUID.set(stack, new LinkedHashSet<UUID>(list));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        List<UUID> ids = this.getList(stack);
        if (!ids.isEmpty() && !flag.hasShiftDown()) {
            for (UUID e : ids) {
                list.add(this.getName(e));
            }
            list.add((Component)MGLangData.TARGET_SHIFT.get(new Object[0]));
        } else {
            list.add((Component)MGLangData.TARGET_UUID_ADD.get(new Object[0]));
            list.add((Component)MGLangData.TARGET_UUID_REMOVE.get(new Object[0]));
            list.add((Component)MGLangData.TARGET_REMOVE.get(new Object[0]));
        }
    }
}

