/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.card;

import dev.xkmc.modulargolems.content.client.outline.BlockOutliner;
import dev.xkmc.modulargolems.init.data.MGLangData;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PathRecordCard
extends Item {
    @Nullable
    public static Pos getList(ItemStack stack) {
        return (Pos)GolemItems.DC_PATH.get(stack);
    }

    public static void addPos(ItemStack stack, Level level, BlockPos pos) {
        ResourceLocation id = level.dimension().location();
        Pos old = PathRecordCard.getList(stack);
        if (old != null && old.level.equals((Object)id)) {
            old = old.copy();
            old.pos.add(pos);
            GolemItems.DC_PATH.set(stack, (Object)old);
        } else {
            GolemItems.DC_PATH.set(stack, (Object)new Pos(id, new ArrayList<BlockPos>(List.of(pos))));
        }
    }

    public static boolean togglePos(ItemStack stack, Level level, BlockPos pos) {
        ResourceLocation id = level.dimension().location();
        Pos ans = PathRecordCard.getList(stack);
        if (ans == null || !ans.level().equals((Object)id) || !ans.pos().contains(pos)) {
            PathRecordCard.addPos(stack, level, pos);
            return true;
        }
        ans = ans.copy();
        ans.pos().remove(pos);
        if (ans.pos.isEmpty()) {
            stack.remove(GolemItems.DC_PATH);
        } else {
            GolemItems.DC_PATH.set(stack, (Object)ans);
        }
        return false;
    }

    public PathRecordCard(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        ItemStack stack = ctx.getItemInHand();
        Level level = ctx.getLevel();
        if (!level.isClientSide()) {
            Pos list;
            Player player = ctx.getPlayer();
            if (player != null && player.isShiftKeyDown()) {
                stack.remove(GolemItems.DC_PATH);
                player.sendSystemMessage((Component)MGLangData.PATH_CLEAR.get(new Object[0]));
                return InteractionResult.SUCCESS;
            }
            BlockPos pos = ctx.getClickedPos();
            BlockState state = level.getBlockState(pos);
            if (!state.getShape((BlockGetter)level, pos).isEmpty()) {
                pos = pos.relative(ctx.getClickedFace());
            }
            if ((list = PathRecordCard.getList(stack)) != null && !list.pos.isEmpty()) {
                BlockPos last = list.pos.getLast();
                if (!list.match(level)) {
                    if (player != null) {
                        player.sendSystemMessage((Component)MGLangData.PATH_ERR_DIM.get(new Object[0]));
                    }
                    return InteractionResult.FAIL;
                }
                if (!list.pos().contains(pos) && pos.distSqr((Vec3i)last) > 256.0) {
                    if (player != null) {
                        player.sendSystemMessage((Component)MGLangData.PATH_ERR_DIST.get(new Object[0]));
                    }
                    return InteractionResult.FAIL;
                }
            }
            if (PathRecordCard.togglePos(stack, level, pos)) {
                if (player != null) {
                    player.sendSystemMessage((Component)MGLangData.PATH_ADD.get(new Object[0]));
                }
            } else if (player != null) {
                player.sendSystemMessage((Component)MGLangData.PATH_REMOVE.get(new Object[0]));
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (selected && entity instanceof Player) {
            Pos pos;
            Player player = (Player)entity;
            if (level.isClientSide() && (pos = PathRecordCard.getList(stack)) != null && pos.level().equals((Object)level.dimension().location())) {
                BlockOutliner.drawOutlines(player, pos.pos);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        int size = Optional.ofNullable(PathRecordCard.getList(stack)).map(e -> e.pos().size()).orElse(0);
        list.add((Component)MGLangData.PATH_COUNT.get(Component.literal((String)("" + size)).withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.GRAY));
        list.add((Component)MGLangData.PATH.get(new Object[0]).withStyle(ChatFormatting.GRAY));
    }

    public record Pos(ResourceLocation level, ArrayList<BlockPos> pos) {
        public Pos copy() {
            return new Pos(this.level, new ArrayList<BlockPos>(this.pos));
        }

        public boolean match(Level level) {
            return this.level().equals((Object)level.dimension().location());
        }
    }
}

