/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.card;

import com.mojang.datafixers.util.Either;
import dev.xkmc.modulargolems.content.item.card.TargetFilterCard;
import dev.xkmc.modulargolems.init.data.MGLangData;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class NameFilterCard
extends TargetFilterCard {
    private static List<String> getStrings(ItemStack stack) {
        return (List)GolemItems.DC_FILTER_NAME.getOrDefault(stack, List.of());
    }

    private static List<Either<EntityType<?>, TagKey<EntityType<?>>>> getList(List<String> strs) {
        ArrayList ans = new ArrayList();
        for (String s : strs) {
            ResourceLocation rl;
            String str = s.trim();
            if (str.startsWith("#")) {
                TagKey key;
                Optional ref;
                rl = ResourceLocation.tryParse((String)str.substring(1));
                if (rl == null || !(ref = BuiltInRegistries.ENTITY_TYPE.getTag(key = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)rl))).isPresent()) continue;
                ans.add(Either.right((Object)key));
                continue;
            }
            rl = ResourceLocation.tryParse((String)str);
            if (rl == null || !BuiltInRegistries.ENTITY_TYPE.containsKey(rl)) continue;
            EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(rl);
            ans.add(Either.left((Object)type));
        }
        return ans;
    }

    public static void setList(ItemStack stack, List<Either<EntityType<?>, TagKey<EntityType<?>>>> list) {
        GolemItems.DC_FILTER_NAME.set(stack, list.stream().map(e -> (String)e.map(l -> BuiltInRegistries.ENTITY_TYPE.getKey(l).toString(), r -> "#" + String.valueOf(r.location()))).toList());
    }

    public NameFilterCard(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack getFriendly() {
        ItemStack friendly = GolemItems.CARD_NAME.asStack();
        NameFilterCard.setList(friendly, List.of(Either.right(MGTagGen.GOLEM_FRIENDLY)));
        return friendly;
    }

    @Override
    public Predicate<LivingEntity> mayTarget(ItemStack stack) {
        List<Either<EntityType<?>, TagKey<EntityType<?>>>> list = NameFilterCard.getList(NameFilterCard.getStrings(stack));
        return e -> {
            for (Either x : list) {
                if (!((Boolean)x.map(l -> e.getType() == l, r -> e.getType().is(r))).booleanValue()) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    protected InteractionResultHolder<ItemStack> removeLast(Player player, ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>(NameFilterCard.getStrings(stack));
        if (list.isEmpty()) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!player.level().isClientSide()) {
            String e = list.removeLast();
            NameFilterCard.setList(stack, NameFilterCard.getList(list));
            player.sendSystemMessage((Component)MGLangData.TARGET_MSG_REMOVED.get(Component.literal((String)e)));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    protected InteractionResultHolder<ItemStack> onUse(Player player, ItemStack stack) {
        String name;
        ArrayList<String> strs = new ArrayList<String>(NameFilterCard.getStrings(stack));
        if (strs.contains(name = stack.getHoverName().getString())) {
            return InteractionResultHolder.success((Object)stack);
        }
        if (!player.level().isClientSide()) {
            strs.add(name);
            NameFilterCard.setList(stack, NameFilterCard.getList(strs));
            stack.remove(DataComponents.CUSTOM_NAME);
            player.sendSystemMessage((Component)MGLangData.TARGET_MSG_ADDED.get(Component.literal((String)name)));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        List<String> strs = NameFilterCard.getStrings(stack);
        if (!strs.isEmpty() && !flag.hasShiftDown()) {
            for (String e : strs) {
                list.add((Component)Component.literal((String)e));
            }
            list.add((Component)MGLangData.TARGET_SHIFT.get(new Object[0]));
        } else {
            list.add((Component)MGLangData.TARGET_NAME.get(new Object[0]));
            list.add((Component)MGLangData.TARGET_REMOVE.get(new Object[0]));
        }
    }
}

