/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.card;

import dev.xkmc.l2core.util.Proxy;
import dev.xkmc.modulargolems.content.capability.GolemConfigEditor;
import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.capability.GolemConfigStorage;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.item.wand.GolemInteractItem;
import dev.xkmc.modulargolems.content.menu.config.ConfigMenuProvider;
import dev.xkmc.modulargolems.init.data.MGLangData;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ConfigCard
extends Item
implements GolemInteractItem {
    private final DyeColor color;

    @Nullable
    public static UUID getUUID(ItemStack stack) {
        return (UUID)GolemItems.DC_OWNER.get(stack);
    }

    public static Predicate<AbstractGolemEntity<?, ?>> getFilter(Player player) {
        ItemStack stack = player.getOffhandItem();
        Item item = stack.getItem();
        if (item instanceof ConfigCard) {
            ConfigCard card = (ConfigCard)item;
            UUID uuid = ConfigCard.getUUID(stack);
            if (uuid != null) {
                return e -> Optional.ofNullable(e.getConfigEntry(null)).map(x -> x.getID().equals(uuid) && x.getColor() == card.color.getId()).orElse(true);
            }
        }
        return e -> true;
    }

    private static boolean mayClientEdit(UUID id) {
        LocalPlayer player = Proxy.getClientPlayer();
        return player != null && player.getUUID().equals(id);
    }

    public ConfigCard(Item.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        UUID uuid;
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            uuid = ConfigCard.getUUID(stack);
            if (uuid == null) {
                uuid = player.getUUID();
                GolemItems.DC_OWNER.set(stack, (Object)uuid);
            }
            if (player.getUUID().equals(uuid)) {
                GolemConfigEntry entry = GolemConfigStorage.get((Level)sl).getOrCreateStorage(uuid, this.color.getId(), stack.getHoverName());
                entry.setName(stack.getHoverName(), sl);
                entry.heartBeat(sl, (ServerPlayer)player);
            }
        }
        if (target instanceof AbstractGolemEntity) {
            GolemConfigEntry old;
            AbstractGolemEntity golem = (AbstractGolemEntity)target;
            if (!golem.canModify(player)) {
                return InteractionResult.FAIL;
            }
            if (player.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            uuid = ConfigCard.getUUID(stack);
            if (uuid == null) {
                uuid = player.getUUID();
                GolemItems.DC_OWNER.set(stack, (Object)uuid);
            }
            if ((old = golem.getConfigEntry(null)) != null && old.getID().equals(uuid) && old.getColor() == this.color.getId()) {
                golem.setConfigCard(null, 0);
            } else {
                golem.setConfigCard(uuid, this.color.getId());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        UUID uuid = ConfigCard.getUUID(stack);
        if (uuid == null) {
            uuid = player.getUUID();
            GolemItems.DC_OWNER.set(stack, (Object)uuid);
        }
        if (level instanceof ServerLevel) {
            GolemConfigEditor.Writable editor;
            ServerLevel sl = (ServerLevel)level;
            if (player.getUUID().equals(uuid)) {
                GolemConfigEntry entry = GolemConfigStorage.get(level).getOrCreateStorage(uuid, this.color.getId(), stack.getHoverName());
                entry.setName(stack.getHoverName(), sl);
                entry.heartBeat(sl, (ServerPlayer)player);
                editor = new GolemConfigEditor.Writable(level, entry);
            } else {
                GolemConfigEntry entry = GolemConfigStorage.get(level).getStorage(uuid, this.color.getId());
                editor = entry != null ? new GolemConfigEditor.Writable(level, entry) : null;
            }
            if (editor != null && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                ConfigMenuProvider pvd = new ConfigMenuProvider(uuid, this.color.getId(), editor);
                sp.openMenu((MenuProvider)pvd, pvd::writeBuffer);
                return InteractionResultHolder.success((Object)stack);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        UUID id = ConfigCard.getUUID(stack);
        if (id == null) {
            list.add((Component)MGLangData.CONFIG_INIT.get(new Object[0]));
        } else {
            Level level = ctx.level();
            if (level != null) {
                GolemConfigEntry entry = GolemConfigStorage.get(level).getOrCreateStorage(id, this.color.getId(), (Component)MGLangData.LOADING.get(new Object[0]));
                entry.clientTick(level, false);
                list.add(entry.getDisplayName());
            }
            if (!ConfigCard.mayClientEdit(id)) {
                list.add((Component)MGLangData.CONFIG_OTHER.get(new Object[0]));
            }
            list.add((Component)MGLangData.CONFIG_CARD.get(new Object[0]));
        }
    }
}

