/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.card;

import dev.xkmc.modulargolems.content.item.card.TargetFilterCard;
import dev.xkmc.modulargolems.init.data.MGLangData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class ClickEntityFilterCard<T>
extends TargetFilterCard {
    public ClickEntityFilterCard(Item.Properties properties) {
        super(properties);
    }

    protected abstract List<T> getList(ItemStack var1);

    protected abstract T getValue(LivingEntity var1);

    protected abstract Component getName(T var1);

    protected abstract void setList(ItemStack var1, List<T> var2);

    protected InteractionResult addTargetEntity(Player player, ItemStack stack, LivingEntity target) {
        ArrayList<T> list = new ArrayList<T>(this.getList(stack));
        if (list.contains(this.getValue(target))) {
            return InteractionResult.SUCCESS;
        }
        if (!player.level().isClientSide()) {
            T val = this.getValue(target);
            list.add(val);
            this.setList(stack, list);
            player.sendSystemMessage((Component)MGLangData.TARGET_MSG_ADDED.get(this.getName(val)));
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult removeTargetEntity(Player player, ItemStack stack, LivingEntity target) {
        T val;
        ArrayList<T> list = new ArrayList<T>(this.getList(stack));
        if (!list.contains(this.getValue(target))) {
            return InteractionResult.FAIL;
        }
        if (!player.level().isClientSide() && list.remove(val = this.getValue(target))) {
            this.setList(stack, list);
            player.sendSystemMessage((Component)MGLangData.TARGET_MSG_REMOVED.get(this.getName(val)));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected InteractionResultHolder<ItemStack> removeLast(Player player, ItemStack stack) {
        ArrayList<T> list = new ArrayList<T>(this.getList(stack));
        if (list.isEmpty()) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!player.level().isClientSide()) {
            T val = list.removeLast();
            this.setList(stack, list);
            player.sendSystemMessage((Component)MGLangData.TARGET_MSG_REMOVED.get(this.getName(val)));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    public Predicate<LivingEntity> mayTarget(ItemStack stack) {
        HashSet<T> set = new HashSet<T>(this.getList(stack));
        return e -> set.contains(this.getValue((LivingEntity)e));
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        ItemStack item = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            return this.removeTargetEntity(player, item, target);
        }
        return this.addTargetEntity(player, item, target);
    }
}

