/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.targeting;

import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.hostile.HostileFaction;
import dev.xkmc.modulargolems.content.entity.hostile.HostileGolemRegistry;
import dev.xkmc.modulargolems.content.entity.targeting.TargetEntry;
import dev.xkmc.modulargolems.content.entity.targeting.TargetingReason;
import dev.xkmc.modulargolems.content.entity.targeting.TargetingStatus;
import dev.xkmc.modulargolems.content.item.card.DefaultFilterCard;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TargetManager {
    private static final Map<ServerLevel, Map<UUID, TargetManager>> MAP = new ConcurrentHashMap<ServerLevel, Map<UUID, TargetManager>>();
    private static final TargetManager DUMMY = new TargetManager();
    private final LinkedHashMap<UUID, TargetEntry> map = new LinkedHashMap();
    private long prevTime;

    public static TargetManager get(AbstractGolemEntity<?, ?> golem) {
        Level level = golem.level();
        if (!(level instanceof ServerLevel)) {
            return DUMMY;
        }
        ServerLevel sl = (ServerLevel)level;
        UUID id = golem.getOwnerUUID();
        if (id == null) {
            return DUMMY;
        }
        return MAP.computeIfAbsent(sl, e -> new LinkedHashMap()).computeIfAbsent(id, e -> new TargetManager());
    }

    @Nullable
    public static TargetingReason predicateTarget(AbstractGolemEntity<?, ?> self, LivingEntity e) {
        Mob mob;
        if (TargetManager.isFriend(self, (Entity)e.getLastHurtMob())) {
            return TargetingReason.HURT;
        }
        if (e instanceof Mob && TargetManager.isFriend(self, (Entity)(mob = (Mob)e).getTarget())) {
            return TargetingReason.MALICE;
        }
        if (TargetManager.wantsToAttack(self, e)) {
            return TargetingReason.PREY;
        }
        if (TargetManager.isFriend(self, (Entity)e.getLastHurtByMob())) {
            return TargetingReason.PREVIOUS;
        }
        return null;
    }

    private static boolean isFriend(AbstractGolemEntity<?, ?> self, @Nullable Entity target) {
        if (target == null) {
            return false;
        }
        return target == self.getOwner() || target == self.getLeader() || target.isAlliedTo(self) || self.isAlliedTo(target);
    }

    private static boolean wantsToAttack(AbstractGolemEntity<?, ?> self, LivingEntity e) {
        GolemConfigEntry config = self.getConfigEntry(null);
        if (config == null) {
            Optional<HostileFaction> opt = HostileGolemRegistry.tryGetFaction(self);
            if (opt.isPresent()) {
                return opt.get().hostileGolemAttacks(self, e);
            }
            return DefaultFilterCard.defaultPredicate(e);
        }
        return config.targetFilter.aggressiveToward(e);
    }

    @Nullable
    public static LivingEntity findBestTarget(AbstractGolemEntity<?, ?> self, ArrayList<TargetingStatus> list) {
        double best = -100000.0;
        LivingEntity ans = null;
        for (TargetingStatus e : list) {
            double score = (double)e.eval(self) + self.getRandom().nextDouble();
            if (!(score > best)) continue;
            best = score;
            ans = e.target();
        }
        return ans;
    }

    public void onSetTarget(AbstractGolemEntity<?, ?> self, LivingEntity target) {
        this.map.computeIfAbsent(target.getUUID(), k -> new TargetEntry()).put(self.level().getGameTime(), self);
    }

    public void tickTarget(AbstractGolemEntity<?, ?> self, LivingEntity target) {
        long time = self.level().getGameTime();
        if (time > this.prevTime + 5L) {
            this.prevTime = time;
            HashSet<UUID> toRemove = new HashSet<UUID>();
            for (Map.Entry<UUID, TargetEntry> ent : this.map.entrySet()) {
                if (ent.getValue().getLastTick() >= time - 5L) continue;
                toRemove.add(ent.getKey());
            }
            for (UUID e : toRemove) {
                this.map.remove(e);
            }
        }
        this.map.computeIfAbsent(target.getUUID(), k -> new TargetEntry()).tick(time, self);
    }

    public int getPrevCount(AbstractGolemEntity<?, ?> self, LivingEntity target) {
        return this.map.computeIfAbsent(target.getUUID(), k -> new TargetEntry()).get(self.level().getGameTime(), self);
    }
}

