/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.targeting;

import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.targeting.TargetManager;
import dev.xkmc.modulargolems.content.entity.targeting.TargetingReason;
import dev.xkmc.modulargolems.content.entity.targeting.TargetingStatus;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Golem3DTargetGoal
extends NearestAttackableTargetGoal<LivingEntity> {
    private final AbstractGolemEntity<?, ?> self;

    public Golem3DTargetGoal(AbstractGolemEntity<?, ?> self, int interval) {
        super(self, LivingEntity.class, interval, false, false, self::predicateTarget);
        this.self = self;
    }

    protected void findTarget() {
        List entities = this.self.level().getEntitiesOfClass(this.targetType, this.getTargetSearchArea(this.getFollowDistance()));
        ArrayList<TargetingStatus> list = new ArrayList<TargetingStatus>();
        Vec3 cen = this.self.getEyePosition();
        AABB box = this.self.getBoundingBox();
        for (LivingEntity e : entities) {
            TargetingReason reason;
            if (!this.targetConditions.test(this.self, e) || (reason = TargetManager.predicateTarget(this.self, e)) == null) continue;
            AABB ebox = e.getBoundingBox();
            double yDiff = Math.max(ebox.minY - box.maxY, box.minY - ebox.maxY);
            list.add(new TargetingStatus(e, reason, TargetManager.get(this.self).getPrevCount(this.self, e), e.distanceToSqr(cen), yDiff));
        }
        this.target = TargetManager.findBestTarget(this.self, list);
    }

    protected AABB getTargetSearchArea(double r) {
        return this.mob.getBoundingBox().inflate(r, r, r);
    }
}

