/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.metalgolem;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xkmc.modulargolems.content.client.armor.GolemEquipmentModels;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemRenderer;
import dev.xkmc.modulargolems.content.entity.common.GolemBannerLayer;
import dev.xkmc.modulargolems.content.entity.metalgolem.GolemEquipmentRenderer;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemCrackinessLayer;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemModel;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemPartType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.Nullable;

public class MetalGolemRenderer
extends AbstractGolemRenderer<MetalGolemEntity, MetalGolemPartType, MetalGolemModel> {
    protected static void transform(PoseStack stack, ItemDisplayContext transform, @Nullable MetalGolemPartType part) {
        float size;
        switch (transform) {
            case GUI: 
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                break;
            }
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                stack.translate(0.25, 0.4, 0.5);
                size = 0.625f;
                stack.scale(size, size, size);
                break;
            }
            case GROUND: {
                stack.translate(0.25, 0.0, 0.5);
                size = 0.625f;
                stack.scale(size, size, size);
                break;
            }
            case NONE: 
            case HEAD: 
            case FIXED: {
                stack.translate(0.5, 0.5, 0.5);
                float size2 = 0.45f;
                stack.scale(size2, -size2, size2);
                stack.translate(0.0, -0.15, 0.0);
                return;
            }
            default: {
                stack.translate(0.0, 0.0, 0.5);
            }
        }
        stack.mulPose(Axis.ZP.rotationDegrees(135.0f));
        stack.mulPose(Axis.YP.rotationDegrees(-155.0f));
        if (part == null) {
            size = 0.375f;
            stack.scale(size, size, size);
            stack.translate(0.0, -2.2, 0.0);
        } else if (part == MetalGolemPartType.BODY) {
            size = 0.525f;
            stack.scale(size, size, size);
            stack.translate(0.0f, -1.0f, 0.0f);
        } else if (part == MetalGolemPartType.LEG) {
            size = 0.6f;
            stack.scale(size, size, size);
            stack.translate(0.0, -2.2, 0.0);
        } else if (part == MetalGolemPartType.LEFT) {
            size = 0.55f;
            stack.scale(size, size, size);
            stack.translate(-0.7, -1.7, 0.0);
        }
    }

    public MetalGolemRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new MetalGolemModel(ctx.bakeLayer(GolemEquipmentModels.METALGOLEM)), 0.7f, MetalGolemPartType::values);
        this.addLayer(new MetalGolemCrackinessLayer((RenderLayerParent<MetalGolemEntity, MetalGolemModel>)this));
        this.addLayer(new GolemEquipmentRenderer((RenderLayerParent<MetalGolemEntity, MetalGolemModel>)this, ctx));
        this.addLayer(new GolemBannerLayer(this, ctx.getItemInHandRenderer()));
    }

    protected void setupRotations(MetalGolemEntity entity, PoseStack stack, float bob, float yr, float pt, float scale) {
        super.setupRotations((LivingEntity)entity, stack, bob, yr, pt, scale);
        if (!((double)entity.walkAnimation.speed() < 0.01)) {
            float f = 13.0f;
            float f1 = entity.walkAnimation.position() - entity.walkAnimation.speed() * (1.0f - pt) + 6.0f;
            float f2 = (Math.abs(f1 % f - 6.5f) - 3.25f) / 3.25f;
            stack.mulPose(Axis.ZP.rotationDegrees(6.5f * f2));
        }
    }
}

