/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.metalgolem;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xkmc.modulargolems.content.client.armor.GolemEquipmentModels;
import dev.xkmc.modulargolems.content.client.pose.MetalGolemPose;
import dev.xkmc.modulargolems.content.client.pose.WeaponPose;
import dev.xkmc.modulargolems.content.entity.common.IGolemModel;
import dev.xkmc.modulargolems.content.entity.common.IHeadedModel;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemPartType;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;

public class MetalGolemModel
extends HierarchicalModel<MetalGolemEntity>
implements IGolemModel<MetalGolemEntity, MetalGolemPartType, MetalGolemModel>,
IHeadedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart body;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart leftForeArm;
    public final ModelPart rightForeArm;

    public MetalGolemModel(EntityModelSet set) {
        this(set.bakeLayer(GolemEquipmentModels.METALGOLEM));
    }

    public MetalGolemModel(ModelPart part) {
        this.root = part;
        this.body = part.getChild("body");
        this.head = part.getChild("head");
        this.rightArm = part.getChild("right_arm");
        this.leftArm = part.getChild("left_arm");
        this.rightLeg = part.getChild("right_leg");
        this.leftLeg = part.getChild("left_leg");
        this.leftForeArm = this.leftArm.getChild("left_forearm");
        this.rightForeArm = this.rightArm.getChild("right_forearm");
    }

    public ModelPart root() {
        return this.root;
    }

    public void copyFrom(MetalGolemModel other) {
        this.head.copyFrom(other.head);
        this.body.copyFrom(other.body);
        this.rightArm.copyFrom(other.rightArm);
        this.leftArm.copyFrom(other.leftArm);
        this.rightLeg.copyFrom(other.rightLeg);
        this.leftLeg.copyFrom(other.leftLeg);
        this.leftForeArm.copyFrom(other.leftForeArm);
        this.rightForeArm.copyFrom(other.rightForeArm);
    }

    public void setupAnim(MetalGolemEntity entity, float f1, float f2, float f3, float f4, float f5) {
        this.root.resetPose();
        this.head.yRot = f4 * ((float)Math.PI / 180);
        this.head.xRot = f5 * ((float)Math.PI / 180);
        this.rightLeg.xRot = -1.5f * Mth.triangleWave((float)f1, (float)13.0f) * f2;
        this.leftLeg.xRot = 1.5f * Mth.triangleWave((float)f1, (float)13.0f) * f2;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        if (this.riding) {
            this.rightLeg.xRot = -1.4137167f;
            this.rightLeg.yRot = 0.31415927f;
            this.rightLeg.zRot = 0.07853982f;
            this.leftLeg.xRot = -1.4137167f;
            this.leftLeg.yRot = -0.31415927f;
            this.leftLeg.zRot = -0.07853982f;
        }
    }

    public void prepareMobModel(MetalGolemEntity entity, float bob, float speed, float pTick) {
        int atkTick;
        MetalGolemPose pose = MetalGolemPose.DEFAULT;
        if (!entity.getMainHandItem().isEmpty()) {
            pose = WeaponPose.WEAPON;
        }
        if ((atkTick = entity.getAttackAnimationTick()) > 0) {
            pose.attackModel(entity, this, (float)atkTick - pTick);
        } else if (entity.isAggressive()) {
            pose.aggressive(entity, this, bob, speed, pTick);
        } else {
            pose.walking(entity, this, bob, speed, pTick);
        }
    }

    @Override
    public void renderToBufferInternal(MetalGolemPartType type, PoseStack stack, VertexConsumer consumer, int i, int j, int alpha) {
        if (type == MetalGolemPartType.BODY) {
            this.body.render(stack, consumer, i, j, alpha);
            this.head.render(stack, consumer, i, j, alpha);
        } else if (type == MetalGolemPartType.LEFT) {
            this.leftArm.render(stack, consumer, i, j, alpha);
        } else if (type == MetalGolemPartType.RIGHT) {
            this.rightArm.render(stack, consumer, i, j, alpha);
        } else if (type == MetalGolemPartType.LEG) {
            this.leftLeg.render(stack, consumer, i, j, alpha);
            this.rightLeg.render(stack, consumer, i, j, alpha);
        }
    }

    @Override
    public ResourceLocation getTextureLocationInternal(ResourceLocation rl) {
        return rl.withPath(e -> "textures/entity/metal_golem/" + e + ".png");
    }

    public void transformToHand(EquipmentSlot slot, PoseStack pose) {
        if (slot == EquipmentSlot.MAINHAND) {
            this.rightArm.translateAndRotate(pose);
            this.rightForeArm.translateAndRotate(pose);
        }
        if (slot == EquipmentSlot.OFFHAND) {
            this.leftArm.translateAndRotate(pose);
            this.leftForeArm.translateAndRotate(pose);
        }
    }

    public ModelPart getHead() {
        return this.head;
    }

    @Override
    public void translateToHead(PoseStack pose) {
        pose.translate(0.0f, -0.45f, -0.08f);
        pose.mulPose(Axis.YP.rotationDegrees(180.0f));
        pose.scale(0.625f, -0.625f, -0.625f);
    }
}

